/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.XString;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class StringTest {
    @Test
    public void cropString() {
        Assert.assertEquals((Object)JuStringUtils.crop((String)"1234567890", (int)5), (Object)"12345");
        Assert.assertEquals((Object)JuStringUtils.crop((String)"1234567890", (int)10), (Object)"1234567890");
        Assert.assertEquals((Object)JuStringUtils.crop((String)"1234567890", (int)11), (Object)"1234567890");
        Assert.assertEquals((Object)JuStringUtils.crop((String)"1234567890", (int)0), (Object)"");
        Assert.assertEquals((Object)JuStringUtils.crop((String)"1234567890", (int)-1), (Object)"");
    }

    @Test
    public void replaceAll() {
        String testString = "bli %key1%, bla %key2%, blu %key1%";
        Assert.assertNull((Object)JuStringUtils.replaceAll(null, (String[])new String[0]));
        Assert.assertEquals((Object)JuStringUtils.replaceAll((String)testString, (String[])new String[0]), (Object)testString);
        Assert.assertEquals((Object)JuStringUtils.replaceAll((String)testString, (String[])new String[]{"blablaKey", "bli"}), (Object)testString);
        Assert.assertEquals((Object)JuStringUtils.replaceAll((String)testString, (String[])new String[]{"key1", "val1"}), (Object)"bli val1, bla %key2%, blu val1");
        Assert.assertEquals((Object)JuStringUtils.replaceAll((String)testString, (String[])new String[]{"key1", "val1", "key2", "val2"}), (Object)"bli val1, bla val2, blu val1");
    }

    @Test
    public void replaceAll_copesWithBackslashes() {
        String testString = "path: %path%";
        String replacedString = JuStringUtils.replaceAll((String)testString, (String[])new String[]{"path", "c:\\test"});
        Assert.assertEquals((Object)"path: c:\\test", (Object)replacedString);
    }

    @Test
    public void occurrancies() {
        String testString = "abbcccddddblabla";
        Assert.assertEquals((long)JuStringUtils.occurrancies((String)testString, (String)"bb"), (long)1L);
        Assert.assertEquals((long)JuStringUtils.occurrancies((String)testString, (String)"a"), (long)3L);
        Assert.assertEquals((long)JuStringUtils.occurrancies((String)testString, (String)"bla"), (long)2L);
        Assert.assertEquals((long)JuStringUtils.occurrancies(null, (String)"bla"), (long)0L);
        Assert.assertEquals((long)JuStringUtils.occurrancies((String)"bla", null), (long)0L);
        Assert.assertEquals((long)JuStringUtils.occurrancies(null, null), (long)0L);
    }

    @Test
    public void containsWhitespace() {
        Assert.assertFalse((boolean)JuStringUtils.containsWhitespace((String)"ThisHasNoWhiteSpace"));
        Assert.assertFalse((boolean)JuStringUtils.containsWhitespace((String)""));
        Assert.assertFalse((boolean)JuStringUtils.containsWhitespace(null));
        Assert.assertTrue((boolean)JuStringUtils.containsWhitespace((String)" "));
        Assert.assertTrue((boolean)JuStringUtils.containsWhitespace((String)"some whitespace"));
        Assert.assertTrue((boolean)JuStringUtils.containsWhitespace((String)"LineBreak\nShouldBeWhitespace"));
    }

    @Test
    public void toStringTest() {
        String str = JuStringUtils.toString((Object)this, (Object[])new Object[]{"one", 1, "two", 2});
        Assert.assertEquals((Object)(this.getClass().getSimpleName() + "[one=1,two=2]"), (Object)str);
    }

    @Test
    public void zuluTime() throws Exception {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.set(1980, 11, 3, 12, 1, 2);
        cal.set(14, 0);
        String zuluTime = JuStringUtils.toZuluDateString((Date)cal.getTime());
        Assert.assertEquals((Object)"1980-12-03T12:01:02.000Z", (Object)zuluTime);
    }

    @Test
    public void loremIpsumParagraphs() {
        TestUtils.assertEqualsResource((String)"StringTest_loremIpsumParagraphs.txt", (String)JuStringUtils.createLoremIpsum().getParagraphs(), (String[])new String[0]);
    }

    @Test
    public void loremIpsumWords() {
        TestUtils.assertEqualsResource((String)"StringTest_loremIpsumWords.txt", (String)JuStringUtils.createLoremIpsum().getWords(15), (String[])new String[0]);
    }

    @Test
    public void removeNonAlphabeticalLeadingCharacters_worksWithAlphabeticallyStartingString() {
        Assert.assertEquals((Object)"abc", (Object)JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)"abc"));
    }

    @Test
    public void removeNonAlphabeticalLeadingCharacters_worksWithNonAlphabeticallyStartingString() {
        Assert.assertEquals((Object)"abc", (Object)JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)"_01_abc"));
        Assert.assertEquals((Object)"a", (Object)JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)"_01_a"));
    }

    @Test
    public void removeNonAlphabeticalLeadingCharacters_worksWithOnlyNonAlphabeticallyString() {
        Assert.assertEquals((Object)"", (Object)JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)"_01_,./__"));
    }

    @Test
    public void removeNonAlphabeticalLeadingCharacters_worksWithNullAndEmptyString() {
        Assert.assertEquals((Object)"", (Object)JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)""));
        Assert.assertNull((Object)JuStringUtils.removeNonAlphabeticalLeadingCharacters(null));
    }

    @Test
    public void split_withoutTrim() {
        TestUtils.assertArrayEquals((Object[])new String[]{"a", "b", "cee"}, (Object[])JuStringUtils.split((String)"a,b,cee", (String)",", (boolean)false));
        TestUtils.assertArrayEquals((Object[])new String[]{" a", " b", " cee"}, (Object[])JuStringUtils.split((String)" a, b, cee", (String)",", (boolean)false));
    }

    @Test
    public void split_withTrim() {
        TestUtils.assertArrayEquals((Object[])new String[]{"a", "b", "cee"}, (Object[])JuStringUtils.split((String)"a, b, cee", (String)",", (boolean)true));
        TestUtils.assertArrayEquals((Object[])new String[]{"a", "b", "cee"}, (Object[])JuStringUtils.split((String)"  a, b  , cee", (String)",", (boolean)true));
        TestUtils.assertArrayEquals((Object[])new String[]{"a", "b", "cee"}, (Object[])JuStringUtils.split((String)"  a, b  , cee   ", (String)",", (boolean)true));
    }

    @Test
    public void formatted_constructor() {
        Assert.assertEquals((Object)"Hello World", (Object)new XString("Hello %s", new Object[]{"World"}).toString());
    }
}

