/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.libs;

import ch.inftec.ju.util.IOUtil;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class SerializableTest {
    @Test
    public void canSerialize_staticInnerClass_withNullReference() {
        StaticInnerClass c = new StaticInnerClass(null);
        Assert.assertNull((Object)IOUtil.isSerializableOrException((Object)c));
    }

    @Test
    public void canNotSerialize_staticInnerClass_withNonNullReference() {
        StaticInnerClass c = new StaticInnerClass(new InnerClass());
        Assert.assertFalse((boolean)IOUtil.isSerializable((Object)c));
    }

    @Test
    public void canSerialize_staticInnerClass_withTransientReference() {
        StaticInnerClassTransient c = new StaticInnerClassTransient(new InnerClass());
        Assert.assertNull((Object)IOUtil.isSerializableOrException((Object)c));
    }

    @Test
    public void canNotSerialize_innerClass() {
        InnerClass c = new InnerClass();
        Assert.assertFalse((boolean)IOUtil.isSerializable((Object)c));
    }

    @Test
    public void canSerialize_staticInnerClass_withInnerClassReference() {
        StaticInnerClass2 c = new StaticInnerClass2();
        Assert.assertTrue((boolean)IOUtil.isSerializable((Object)c));
    }

    @Test
    public void canSerialize_staticInnerClass_withStaticInnerClassCrossReference() {
        StaticInnerClass3 c = new StaticInnerClass3();
        Assert.assertTrue((boolean)IOUtil.isSerializable((Object)c));
    }

    private static class NonSerializableClass {
        private NonSerializableClass() {
        }
    }

    private static class StaticInnerClass3
    implements Serializable {
        private StaticInnerInnerClass innerClass = new StaticInnerInnerClass(this);

        private StaticInnerClass3() {
        }

        private class StaticInnerInnerClass
        implements Serializable {
            private StaticInnerClass3 staticInnerClass;

            public StaticInnerInnerClass(StaticInnerClass3 staticInnerClass) {
                this.staticInnerClass = staticInnerClass;
            }
        }
    }

    private static class StaticInnerClass2
    implements Serializable {
        private InnerInnerClass innerClass = new InnerInnerClass();

        private StaticInnerClass2() {
        }

        private class InnerInnerClass
        implements Serializable {
            private InnerInnerClass() {
            }
        }
    }

    private class InnerClass
    implements Serializable {
        private InnerClass() {
        }
    }

    private static class StaticInnerClassTransient
    implements Serializable {
        private transient InnerClass value;

        private StaticInnerClassTransient(InnerClass value) {
            this.value = value;
        }
    }

    private static class StaticInnerClass
    implements Serializable {
        private InnerClass value;

        private StaticInnerClass(InnerClass value) {
            this.value = value;
        }
    }
}

