/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.libs;

import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.JuStringUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class JavaOcp7Test {
    static String mainMessage = null;
    private static int staticVar;
    private int instVar;

    @Test(expected=NullPointerException.class)
    public void switchWith_nullString() {
        Object s = null;
        s.getClass();
    }

    @Test
    public void instanceOf_withImpossibleType() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void waitAndNotify() throws Exception {
        Printer1 printer1 = new Printer1();
        Printer2 printer2 = new Printer2();
        printer1.start();
        printer2.start();
        Thread.sleep(200L);
        Class<JavaOcp7Test> clazz = JavaOcp7Test.class;
        synchronized (JavaOcp7Test.class) {
            mainMessage = "Message";
            JavaOcp7Test.class.notifyAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            printer1.join();
            printer2.join();
            Assert.assertEquals((long)0L, (long)printer1.interrupted);
            Assert.assertEquals((long)0L, (long)printer2.interrupted);
            Assert.assertEquals((Object)"Message", (Object)printer1.message);
            Assert.assertEquals((Object)"Message", (Object)printer2.message);
            return;
        }
    }

    @Test
    public void formatter() throws Exception {
        Formatter f = new Formatter();
        Assert.assertEquals((Object)"Hello World", (Object)f.format("Hello %s", "World").toString());
        Assert.assertEquals((Object)"Hello World", (Object)String.format("Hello %s", "World"));
        System.out.printf("Hello %s", "World");
        Assert.assertEquals((Object)"Hello World", (Object)String.format("%2$s %1$s", "World", "Hello"));
        Assert.assertEquals((Object)"Hello", (Object)String.format("%2$s", "World", "Hello"));
        Assert.assertEquals((Object)"B B A A B B C", (Object)String.format("%2$s %<s %1$s %s %s %<s %s", "A", "B", "C"));
        Assert.assertEquals((Object)"a", (Object)String.format("%s", "a"));
        Assert.assertEquals((Object)"A", (Object)String.format("%S", "a"));
        Assert.assertEquals((Object)"null", (Object)String.format("%s", new Object[]{null}));
        Assert.assertEquals((Object)"false", (Object)String.format("%b", false));
        Assert.assertEquals((Object)"17", (Object)String.format("%d", 17));
        Assert.assertEquals((Object)"11", (Object)String.format("%h", 17));
        Assert.assertEquals((Object)"null", (Object)String.format("%h", new Object[]{null}));
        Assert.assertEquals((Object)"340282346638528860000000000000000000000.000000", (Object)String.format("%f", Float.valueOf(Float.MAX_VALUE)));
        Assert.assertEquals((Object)"3.40282e+38", (Object)String.format("%g", Float.valueOf(Float.MAX_VALUE)));
        Assert.assertEquals((Object)"0x1.fffffep127", (Object)String.format("%a", Float.valueOf(Float.MAX_VALUE)));
        try {
            Assert.assertEquals((Object)"", (Object)String.format("%f", 17L));
            Assert.fail((String)"Not expected...");
        }
        catch (IllegalFormatConversionException ex) {
            Assert.assertEquals((Object)"f != java.lang.Long", (Object)ex.getMessage());
        }
        Date d = JuStringUtils.DATE_FORMAT_SECONDS.parse("01.02.2003 11:12:13");
        Assert.assertEquals((Object)"2003-02-01", (Object)String.format("%tF", d));
        Assert.assertEquals((Object)"11.12", (Object)String.format("%1$tH.%1$tM", d));
        Assert.assertEquals((Object)"Hello      World", (Object)String.format("%-10s %s", "Hello", "World"));
        Assert.assertEquals((Object)"     Hello World", (Object)String.format("%10s %s", "Hello", "World"));
        Assert.assertEquals((Object)"Hello", (Object)String.format("%1s", "Hello"));
        Assert.assertEquals((Object)" 17", (Object)String.format("%3d", 17));
        Assert.assertEquals((Object)"17.00", (Object)String.format("%3.2f", Float.valueOf(17.0f)));
        Assert.assertEquals((Object)" 1.0", (Object)String.format("%4.1f", Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"017", (Object)String.format("%03d", 17));
        Assert.assertEquals((Object)"+17", (Object)String.format("%+d", 17));
        Assert.assertEquals((Object)"(17)", (Object)String.format("%(d", -17));
    }

    @Test
    public void binarySearch() {
        char[] c = new char[]{'a', 'c', 'd'};
        Assert.assertEquals((long)0L, (long)Arrays.binarySearch(c, 'a'));
        Assert.assertEquals((long)-4L, (long)Arrays.binarySearch(c, 'e'));
        Assert.assertEquals((long)-2L, (long)Arrays.binarySearch(c, 'b'));
        char[] cUnsorted = new char[]{'c', 'a'};
        Assert.assertEquals((long)-1L, (long)Arrays.binarySearch(cUnsorted, 'b'));
    }

    @Test
    public void regularExpressions() {
        Pattern p1 = Pattern.compile("[a-c]");
        Matcher m1 = p1.matcher("0abcde");
        Assert.assertFalse((boolean)m1.matches());
        Object[] split = p1.split("0a1");
        Assert.assertArrayEquals((Object[])new String[]{"0", "1"}, (Object[])split);
        try {
            Assert.assertEquals((long)0L, (long)m1.start());
            Assert.fail((String)"no match available yet");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"No match available", (Object)ex.getMessage());
        }
        Assert.assertTrue((boolean)m1.find());
        Assert.assertEquals((long)0L, (long)m1.regionStart());
        Assert.assertEquals((long)1L, (long)m1.start());
        Assert.assertEquals((Object)"a", (Object)m1.group());
        Assert.assertEquals((Object)"a", (Object)m1.group(0));
        Assert.assertTrue((boolean)m1.find());
        Assert.assertEquals((long)2L, (long)m1.start());
        Assert.assertFalse((boolean)m1.find(4));
        Pattern p2 = Pattern.compile("([ab])((?<middle>.*)[cd])");
        Matcher m2 = p2.matcher("aHellod");
        Assert.assertTrue((boolean)m2.find());
        Assert.assertEquals((Object)"aHellod", (Object)m2.group(0));
        Assert.assertEquals((Object)"a", (Object)m2.group(1));
        Assert.assertEquals((Object)"Hellod", (Object)m2.group(2));
        Assert.assertEquals((Object)"Hello", (Object)m2.group(3));
        Assert.assertEquals((Object)"Hello", (Object)m2.group("middle"));
    }

    @Test
    public void stringTokenizer() {
        StringTokenizer st = new StringTokenizer("Hello World");
        Assert.assertEquals((long)2L, (long)st.countTokens());
        Assert.assertTrue((boolean)st.hasMoreTokens());
        Assert.assertEquals((Object)"Hello", (Object)st.nextToken());
        Assert.assertEquals((Object)"World", (Object)st.nextToken());
        Assert.assertFalse((boolean)st.hasMoreTokens());
    }

    @Test
    public void locale() {
        Assert.assertNotNull((Object)Locale.getDefault());
        Assert.assertNotNull((Object)new Locale("ru", "RU"));
        Locale l = Locale.US;
        Assert.assertEquals((Object)"US", (Object)l.getCountry());
        Assert.assertEquals((Object)"English", (Object)l.getDisplayLanguage());
    }

    @Test
    public void globs() throws Exception {
        Path rootPath = Paths.get("src/test/resources/ch/inftec/ju/util/libs/glob", new String[0]);
        Path pFile1Txt = rootPath.resolve("File1.txt");
        Path pFile1Sql = rootPath.resolve("File1.sql");
        Path pSubFile1Txt = rootPath.resolve("sub/subFile1.txt");
        DirectoryStream<Path> ds = Files.newDirectoryStream(rootPath, "*.txt");
        List paths = JuCollectionUtils.asList(ds);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)pFile1Txt, paths.get(0));
        PathMatcher pm1 = FileSystems.getDefault().getPathMatcher("glob:*");
        Assert.assertFalse((boolean)pm1.matches(pFile1Txt));
        Assert.assertTrue((boolean)pm1.matches(pFile1Txt.getFileName()));
        Assert.assertTrue((boolean)FileSystems.getDefault().getPathMatcher("glob:**").matches(pFile1Txt));
        Assert.assertTrue((boolean)FileSystems.getDefault().getPathMatcher("glob:**.{txt,sql}").matches(pFile1Txt));
        Assert.assertFalse((boolean)FileSystems.getDefault().getPathMatcher("glob:**.{html,xml}").matches(pFile1Txt));
        PathMatcher pm2 = FileSystems.getDefault().getPathMatcher("glob:**/sub/sub[A-F]ile?.{txt,bak}");
        Assert.assertFalse((boolean)pm2.matches(pFile1Txt));
        Assert.assertTrue((boolean)pm2.matches(pSubFile1Txt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void suppressedExceptions() {
        Throwable throwable;
        try {
            SuppressedExceptionTest t = new SuppressedExceptionTest(true, null);
            throwable = null;
            if (t != null) {
                if (throwable != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    t.close();
                }
            }
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"Create", (Object)ex.getMessage());
            Assert.assertEquals((long)0L, (long)ex.getSuppressed().length);
        }
        try {
            throwable = null;
            try (SuppressedExceptionTest t1 = new SuppressedExceptionTest(false, "T1");
                 SuppressedExceptionTest t2 = new SuppressedExceptionTest(false, "T2");){
                SuppressedExceptionTest t3 = new SuppressedExceptionTest(true, null);
                Throwable throwable2 = null;
                if (t3 != null) {
                    if (throwable2 != null) {
                        try {
                            t3.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        t3.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"Create", (Object)ex.getMessage());
            Assert.assertEquals((long)2L, (long)ex.getSuppressed().length);
            Assert.assertEquals((Object)"T2", (Object)ex.getSuppressed()[0].getMessage());
            Assert.assertEquals((Object)"T1", (Object)ex.getSuppressed()[1].getMessage());
        }
    }

    @Test
    public void nestedClasses() {
        StaticNestedClass snc = new StaticNestedClass();
        Assert.assertEquals((long)0L, (long)snc.getStaticVar());
        Assert.assertEquals((Object)"class ch.inftec.ju.util.libs.JavaOcp7Test$StaticNestedClass", (Object)snc.getClass().toString());
        InnerClass ic1 = new InnerClass();
        Assert.assertEquals((long)0L, (long)ic1.getInstVar());
        Assert.assertEquals((Object)"class ch.inftec.ju.util.libs.JavaOcp7Test$InnerClass", (Object)ic1.getClass().toString());
        JavaOcp7Test t2 = new JavaOcp7Test();
        t2.instVar = 1;
        JavaOcp7Test javaOcp7Test = t2;
        javaOcp7Test.getClass();
        InnerClass ic2 = javaOcp7Test.new InnerClass();
        Assert.assertEquals((long)1L, (long)ic2.getInstVar());
        InnerClass ica = new InnerClass(){
            int v1 = 3;

            @Override
            public int getInstVar() {
                return this.v1;
            }
        };
        Assert.assertEquals((long)3L, (long)ica.getInstVar());
        Assert.assertEquals((Object)"class ch.inftec.ju.util.libs.JavaOcp7Test$1", (Object)ica.getClass().toString());
        class LocalClass
        extends InnerClass {
            private int v2;

            LocalClass(int v2) {
                this.v2 = v2;
            }

            public int getV2() {
                return this.v2;
            }
        }
        LocalClass lc1 = new LocalClass(5);
        Assert.assertEquals((long)5L, (long)lc1.getV2());
        Assert.assertEquals((Object)"class ch.inftec.ju.util.libs.JavaOcp7Test$1LocalClass", (Object)lc1.getClass().toString());
    }

    private static String getMsg(String msg) {
        return "My assertion failed: " + msg;
    }

    static /* synthetic */ String access$800(String x0) {
        return JavaOcp7Test.getMsg(x0);
    }

    public static final class AssertTest {
        public static void main(String[] args) {
            int i = 1;
            assert (i < 10) : "One not smaller than 10";
            assert (false) : JavaOcp7Test.access$800("Custom Message");
            System.out.println("Done");
        }
    }

    private class InnerClass {
        private InnerClass() {
        }

        public int getInstVar() {
            return JavaOcp7Test.this.instVar;
        }
    }

    private static class StaticNestedClass {
        private StaticNestedClass() {
        }

        public int getStaticVar() {
            return staticVar;
        }
    }

    private static class SuppressedExceptionTest
    implements AutoCloseable {
        private String closeExceptionMsg;

        public SuppressedExceptionTest(boolean throwExceptionOnCreate, String closeExceptionMsg) {
            if (throwExceptionOnCreate) {
                throw new RuntimeException("Create");
            }
            this.closeExceptionMsg = closeExceptionMsg;
        }

        @Override
        public void close() throws Exception {
            if (this.closeExceptionMsg != null) {
                throw new Exception(this.closeExceptionMsg);
            }
        }
    }

    static class Printer2
    extends Thread {
        private int interrupted;
        private String message;

        Printer2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<JavaOcp7Test> clazz = JavaOcp7Test.class;
            synchronized (JavaOcp7Test.class) {
                while (mainMessage == null) {
                    try {
                        JavaOcp7Test.class.wait();
                    }
                    catch (InterruptedException ex) {
                        ++this.interrupted;
                    }
                }
                this.message = mainMessage;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    static class Printer1
    extends Thread {
        private int interrupted;
        private String message;

        Printer1() {
        }

        @Override
        public void run() {
            while (mainMessage == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    ++this.interrupted;
                }
            }
            this.message = mainMessage;
        }
    }

    static class C
    implements I1,
    I2 {
        C() {
        }

        @Override
        public void m1() {
        }

        @Override
        public int m2() {
            return 0;
        }
    }

    static interface I2 {
        public void m1() throws SQLException;
    }

    static interface I1 {
        public void m1() throws IOException;

        public int m2();
    }
}

