/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.AuthUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration
@RunWith(value=SpringJUnit4ClassRunner.class)
public class AuthUtilTest {
    @Autowired
    private AuthUtil authUtil;

    @Test
    public void authenticate() {
        this.authUtil.logout();
        try {
            this.authUtil.authenticate("user1", "badPwd");
            Assert.fail((String)"Expected exception");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        this.authUtil.authenticate("user1", "pwd1");
    }

    @Test
    public void hasAllRoles() {
        this.authUtil.authenticate("user1", "pwd1");
        Assert.assertTrue((boolean)this.authUtil.hasAllRoles(new String[]{"ROLE_USER"}));
        Assert.assertFalse((boolean)this.authUtil.hasAllRoles(new String[]{"ROLE_ADMIN"}));
        Assert.assertFalse((boolean)this.authUtil.hasAllRoles(new String[]{"ROLE_USER", "ROLE_ADMIN"}));
    }

    @Test
    public void hasAnyRole() {
        this.authUtil.authenticate("user1", "pwd1");
        Assert.assertTrue((boolean)this.authUtil.hasAnyRole(new String[]{"ROLE_USER"}));
        Assert.assertTrue((boolean)this.authUtil.hasAnyRole(new String[]{"ROLE_USER", "ROLE_ADMIN"}));
        Assert.assertFalse((boolean)this.authUtil.hasAnyRole(new String[]{"ROLE_ADMIN"}));
        Assert.assertFalse((boolean)this.authUtil.hasAnyRole(new String[0]));
    }
}

