/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.xml;

import ch.inftec.ju.util.JuRuntimeException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlBuilder {
    private final XmlBuilder parentBuilder;
    private final Document document;
    private final Element element;

    static XmlBuilder createRootBuilder(String rootElementName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            document.setXmlStandalone(true);
            Element rootElement = document.createElement(rootElementName);
            document.appendChild(rootElement);
            return new XmlBuilder(null, document, rootElement);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't initialize XML Document");
        }
    }

    private XmlBuilder(XmlBuilder parentBuilder, Document document, Element element) throws JuRuntimeException {
        this.parentBuilder = parentBuilder;
        this.document = document;
        this.element = element;
    }

    public XmlBuilder setAttribute(String name, String value) {
        this.element.setAttribute(name, value);
        return this;
    }

    public XmlBuilder addText(String text) {
        Text textNode = this.document.createTextNode(text);
        this.element.appendChild(textNode);
        return this;
    }

    public XmlBuilder addChild(String elementName) {
        Element child = this.document.createElement(elementName);
        this.element.appendChild(child);
        return new XmlBuilder(this, this.document, child);
    }

    public XmlBuilder endChild() {
        if (this.parentBuilder == null) {
            throw new IllegalStateException("Cannot call endChild on root builder");
        }
        return this.parentBuilder;
    }

    public Document getDocument() {
        return this.document;
    }
}

