/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.xml;

import ch.inftec.ju.util.JuRuntimeException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathGetter {
    private static XPath xPath;
    private Node node;

    public XPathGetter(Node node) {
        this.node = node;
    }

    private XPath getXPath() {
        if (xPath == null) {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            xPath = xPathFactory.newXPath();
        }
        return xPath;
    }

    private String evaluate(String query) throws JuRuntimeException {
        try {
            XPathExpression xPathExpression = this.getXPath().compile(query);
            return xPathExpression.evaluate(this.node);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't evaluate xPath expression: " + query, ex);
        }
    }

    private NodeList evaluateNodeSet(String query) throws JuRuntimeException {
        try {
            XPathExpression xPathExpression = this.getXPath().compile(query);
            return (NodeList)xPathExpression.evaluate(this.node, XPathConstants.NODESET);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't evaluate xPath expression: " + query, ex);
        }
    }

    public String getSingle(String query) throws JuRuntimeException {
        return this.evaluate(query);
    }

    public Long getSingleLong(String query) throws JuRuntimeException {
        String value = this.getSingle(query);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't convert " + value + " to Long", ex);
        }
    }

    public int getCount(String query) throws JuRuntimeException {
        return this.getNodes(query).length;
    }

    public boolean isEmptyElement(String query) throws JuRuntimeException {
        for (Node node : this.getNodes(query)) {
            if (StringUtils.isEmpty((CharSequence)node.getTextContent()) && node.getChildNodes().getLength() <= 0 && node.getAttributes().getLength() <= 0) continue;
            return false;
        }
        return true;
    }

    public String[] getArray(String query) throws JuRuntimeException {
        try {
            XPathExpression xPathExpression = this.getXPath().compile(query);
            NodeList list = (NodeList)xPathExpression.evaluate(this.node, XPathConstants.NODESET);
            String[] values = new String[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                values[i] = node.getTextContent();
            }
            return values;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't evaluate xPath query: " + query);
        }
    }

    public Long[] getArrayLong(String query) throws JuRuntimeException {
        String[] values = this.getArray(query);
        Long[] longValues = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (value == null || value.length() == 0) {
                longValues[i] = null;
                continue;
            }
            try {
                longValues[i] = Long.parseLong(value);
                continue;
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't convert " + value + " to Long", ex);
            }
        }
        return longValues;
    }

    public NodeList getNodeList(String query) throws JuRuntimeException {
        return this.evaluateNodeSet(query);
    }

    public List<String> getNodeNames(String query) throws JuRuntimeException {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (Node node : this.getNodes(query)) {
            nodeNames.add(node.getNodeName());
        }
        return nodeNames;
    }

    public boolean exists(String query) throws JuRuntimeException {
        return this.evaluateNodeSet(query).getLength() > 0;
    }

    public Node getNode(String query) throws JuRuntimeException {
        NodeList list = this.getNodeList(query);
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    public Node[] getNodes(String query) throws JuRuntimeException {
        NodeList list = this.getNodeList(query);
        Node[] nodes = new Node[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            nodes[i] = list.item(i);
        }
        return nodes;
    }

    public XPathGetter[] getGetters(String query) throws JuRuntimeException {
        NodeList list = this.getNodeList(query);
        XPathGetter[] getters = new XPathGetter[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            getters[i] = new XPathGetter(node);
        }
        return getters;
    }

    public XPathGetter getGetter(String query) throws JuRuntimeException {
        XPathGetter[] getters = this.getGetters(query);
        if (getters.length == 0) {
            return null;
        }
        return getters[0];
    }

    public String[] getDistinctArray(String query) throws JuRuntimeException {
        String[] values = this.getArray(query);
        ArrayList<String> distinctValues = new ArrayList<String>();
        for (String value : values) {
            if (distinctValues.contains(value)) continue;
            distinctValues.add(value);
        }
        return distinctValues.toArray(new String[0]);
    }

    public Long[] getDistinctArrayLong(String query) throws JuRuntimeException {
        String[] distinctValues = this.getDistinctArray(query);
        Long[] distinctValuesLong = new Long[distinctValues.length];
        for (int i = 0; i < distinctValues.length; ++i) {
            try {
                distinctValuesLong[i] = Long.parseLong(distinctValues[i]);
                continue;
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't convert " + distinctValues[i] + " to Long", ex);
            }
        }
        return distinctValuesLong;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("node", (Object)this.node.getNodeName()).append("nodeValue", (Object)this.node.getNodeValue()).toString();
    }
}

