/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.persistable;

import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.XString;
import ch.inftec.ju.util.persistable.GenericMemento;
import ch.inftec.ju.util.persistable.MementoStorage;
import java.util.List;

final class StringMementoStorage
implements MementoStorage {
    public long id = 0L;
    public XString xs = new XString();

    StringMementoStorage() {
    }

    @Override
    public Long persistMemento(GenericMemento memento, String type) {
        long id = this.id++;
        this.xs.addLine("Object: " + id);
        this.xs.increaseIndent();
        for (GenericMemento.MementoAttribute attribute : memento.getAttributes()) {
            this.xs.addLine("Attribute: ", attribute.getKey(), "=");
            if (attribute.getStringValue() != null) {
                this.xs.addText(attribute.getStringValue());
                continue;
            }
            if (attribute.getLongValue() != null) {
                this.xs.addText("L:", attribute.getLongValue());
                continue;
            }
            if (attribute.getDateValue() == null) continue;
            this.xs.addText("D:", JuStringUtils.DATE_FORMAT_SECONDS.format(attribute.getDateValue()));
        }
        for (GenericMemento child : memento.getChildren()) {
            this.persistMemento(child, null);
        }
        this.xs.decreaseIndent();
        return id;
    }

    @Override
    public MementoStorage.GenericMementoItem loadMemento(Long id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        return this.xs.toString();
    }

    @Override
    public List<MementoStorage.GenericMementoItem> loadMementos(int maxCount) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

