/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.persistable;

import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.ReflectUtils;
import ch.inftec.ju.util.persistable.GenericMemento;
import ch.inftec.ju.util.persistable.GenericMementoX;
import ch.inftec.ju.util.persistable.MementoStorage;
import ch.inftec.ju.util.persistable.MemoryMementoStorage;
import ch.inftec.ju.util.persistable.Persistable;
import ch.inftec.ju.util.persistable.PersistableManager;
import ch.inftec.ju.util.persistable.PersistableManagerImpl;
import ch.inftec.ju.util.persistable.StringMementoStorage;
import ch.inftec.ju.util.persistable.TypeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;

public final class GenericMementoUtils {
    public static final TypeHandler DEFAULT_TYPE_HANDLER = new TypeHandlerImpl();

    private GenericMementoUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static GenericMementoX asX(GenericMemento genericMemento) {
        if (genericMemento instanceof GenericMementoX) {
            return (GenericMementoX)genericMemento;
        }
        return new GenericMementoX(genericMemento);
    }

    public static GenericMementoBuilder builder() {
        return new GenericMementoBuilder(null);
    }

    public static MementoStorage newMemoryPersistenceStorage() {
        return new MemoryMementoStorage();
    }

    public static MementoStorage newStringMementoStorage() {
        return new StringMementoStorage();
    }

    public static String persistToString(GenericMemento memento, String type) {
        MementoStorage stringStorage = GenericMementoUtils.newStringMementoStorage();
        stringStorage.persistMemento(memento, type);
        return stringStorage.toString();
    }

    public static PersistableManager newPersistableManager(MementoStorage storage, TypeHandler typeHandler) {
        return new PersistableManagerImpl(storage, typeHandler);
    }

    public static TypeHandlerBuilder newTypeHandler() {
        return new TypeHandlerBuilder();
    }

    static MementoStorage.GenericMementoItem newGenericMementoItem(GenericMemento memento, Long id, String type) {
        return new GenericMementoItemImpl(memento, id, type);
    }

    private static final class TypeHandlerImpl
    implements TypeHandler {
        private static final String MEMENTO_TYPE_FIELD_NAME = "MEMENTO_TYPE_NAME";
        private BidiMap<Class<? extends Persistable>, String> typeNames = new DualHashBidiMap();
        private boolean dynamic = false;

        private TypeHandlerImpl() {
        }

        void addMapping(Class<? extends Persistable> persistableClass) {
            this.setMapping(persistableClass, this.evaluateTypeName(persistableClass));
        }

        void setMapping(Class<? extends Persistable> persistableClass, String typeName) {
            String currentName = (String)this.typeNames.get(persistableClass);
            if (currentName != null && !currentName.equals(typeName) && this.typeNames.containsValue((Object)typeName)) {
                throw new IllegalArgumentException(String.format("Type mapping '%s' has already been defined for %s", typeName, persistableClass));
            }
            this.typeNames.put(persistableClass, (Object)typeName);
        }

        private String evaluateTypeName(Class<? extends Persistable> clazz) {
            return ReflectUtils.getStaticFieldValue(clazz, MEMENTO_TYPE_FIELD_NAME, clazz.getName()).toString();
        }

        @Override
        public String getTypeName(Persistable persistable) {
            if (this.dynamic) {
                this.setMapping(persistable.getClass(), this.evaluateTypeName(persistable.getClass()));
            }
            if (this.typeNames.containsKey(persistable.getClass())) {
                return (String)this.typeNames.get(persistable.getClass());
            }
            return persistable.getClass().getName();
        }

        @Override
        public Persistable newInstance(String typeName) {
            Object obj = null;
            try {
                String className = this.typeNames.containsValue((Object)typeName) ? ((Class)this.typeNames.getKey((Object)typeName)).getName() : typeName;
                obj = ReflectUtils.newInstance(Class.forName(className), true, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Couldn't create instance for type " + typeName, ex);
            }
            if (obj instanceof Persistable) {
                return obj;
            }
            throw new IllegalArgumentException("Class for " + typeName + " does not implement Persistable");
        }
    }

    public static final class TypeHandlerBuilder {
        private TypeHandlerImpl typeHandler = new TypeHandlerImpl();

        TypeHandlerBuilder() {
        }

        public TypeHandlerBuilder dynamic(boolean dynamic) {
            this.typeHandler.dynamic = dynamic;
            return this;
        }

        public TypeHandlerBuilder addMapping(Class<? extends Persistable> clazz) {
            this.typeHandler.addMapping(clazz);
            return this;
        }

        public TypeHandlerBuilder setMapping(Class<? extends Persistable> clazz, String typeName) {
            this.typeHandler.setMapping(clazz, typeName);
            return this;
        }

        public TypeHandler getHandler() {
            return this.typeHandler;
        }
    }

    public static final class GenericMementoBuilder {
        private GenericMementoImpl genericMemento = new GenericMementoImpl();
        private GenericMementoBuilder parentBuilder;

        private GenericMementoBuilder(GenericMementoBuilder parentBuilder) {
            this.parentBuilder = parentBuilder;
        }

        public GenericMementoBuilder newChild() {
            return new GenericMementoBuilder(this);
        }

        public GenericMementoBuilder childDone() {
            if (this.parentBuilder == null) {
                throw new IllegalStateException("This is the root builder");
            }
            this.parentBuilder.genericMemento.addChild(this.genericMemento);
            return this.parentBuilder;
        }

        public GenericMementoBuilder addString(String key, String value) {
            this.genericMemento.addAttribute(key, value);
            return this;
        }

        public GenericMementoBuilder addLong(String key, Long value) {
            this.genericMemento.addAttribute(key, value);
            return this;
        }

        public GenericMementoBuilder addDate(String key, Date value) {
            this.genericMemento.addAttribute(key, value);
            return this;
        }

        public GenericMementoBuilder add(String key, Object value) {
            this.genericMemento.addAttribute(key, value);
            return this;
        }

        public GenericMementoBuilder add(String key, String sVal, Date dVal, Long lVal) {
            this.genericMemento.addAttribute(key, sVal, dVal, lVal);
            return this;
        }

        public GenericMementoBuilder add(GenericMemento.MementoAttribute attribute) {
            this.genericMemento.addAttribute(attribute);
            return this;
        }

        public GenericMementoBuilder add(GenericMemento memento) {
            for (GenericMemento.MementoAttribute attribute : memento.getAttributes()) {
                this.add(attribute);
            }
            for (GenericMemento child : memento.getChildren()) {
                this.newChild().add(child).childDone();
            }
            return this;
        }

        public GenericMemento build() {
            if (this.parentBuilder != null) {
                throw new IllegalStateException("Build can only be called on the root builder. Close all childs using childDone first.");
            }
            return this.genericMemento;
        }
    }

    private static final class GenericMementoItemImpl
    implements MementoStorage.GenericMementoItem {
        GenericMemento memento;
        Long id;
        String type;

        private GenericMementoItemImpl(GenericMemento memento, Long id, String type) {
            this.memento = memento;
            this.id = id;
            this.type = type;
        }

        @Override
        public GenericMemento getMemento() {
            return this.memento;
        }

        @Override
        public Long getId() {
            return this.id;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String toString() {
            return JuStringUtils.toString(this, "id", this.getId(), "type", this.getType());
        }
    }

    private static final class MementoAttributeImpl
    implements GenericMemento.MementoAttribute {
        String key;
        String stringValue;
        Date dateValue;
        Long longValue;

        MementoAttributeImpl(String key, String value) {
            this(key, value, null, null);
        }

        MementoAttributeImpl(String key, Date value) {
            this(key, null, value, null);
        }

        MementoAttributeImpl(String key, Long value) {
            this(key, null, null, value);
        }

        MementoAttributeImpl(String key, String stringValue, Date dateValue, Long longValue) {
            this.key = key;
            this.stringValue = stringValue;
            this.dateValue = dateValue;
            this.longValue = longValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getStringValue() {
            return this.stringValue;
        }

        @Override
        public Date getDateValue() {
            return this.dateValue;
        }

        @Override
        public Long getLongValue() {
            return this.longValue;
        }

        public String toString() {
            return JuStringUtils.toString(this, "key", this.getKey(), "stringValue", this.getStringValue(), "longValue", this.getLongValue(), "dateValue", this.getDateValue());
        }
    }

    private static final class GenericMementoImpl
    implements GenericMemento {
        ArrayList<GenericMemento> children = new ArrayList();
        ArrayList<GenericMemento.MementoAttribute> attributes = new ArrayList();

        private GenericMementoImpl() {
        }

        void addAttribute(String key, String value) {
            this.attributes.add(new MementoAttributeImpl(key, value));
        }

        void addAttribute(String key, Date value) {
            this.attributes.add(new MementoAttributeImpl(key, value));
        }

        void addAttribute(String key, Long value) {
            this.attributes.add(new MementoAttributeImpl(key, value));
        }

        void addAttribute(String key, Object value) {
            if (value == null) {
                this.addAttribute(key, (String)null);
            } else if (value instanceof String) {
                this.addAttribute(key, (String)value);
            } else if (value instanceof Long) {
                this.addAttribute(key, (Long)value);
            } else if (value instanceof Integer) {
                this.addAttribute(key, new Long(((Integer)value).intValue()));
            } else if (value instanceof Date) {
                this.addAttribute(key, (Date)value);
            } else {
                throw new IllegalArgumentException("Illegal data type: " + value.getClass());
            }
        }

        void addAttribute(String key, String stringValue, Date dateValue, Long longValue) {
            this.attributes.add(new MementoAttributeImpl(key, stringValue, dateValue, longValue));
        }

        void addAttribute(GenericMemento.MementoAttribute attribute) {
            this.attributes.add(attribute);
        }

        void addChild(GenericMemento child) {
            this.children.add(child);
        }

        @Override
        public List<GenericMemento> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        @Override
        public List<GenericMemento.MementoAttribute> getAttributes() {
            return Collections.unmodifiableList(this.attributes);
        }

        public String toString() {
            return JuStringUtils.toString(this, "childrenCount", this.children.size(), "attributesCount", this.attributes.size());
        }
    }
}

