/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.helper;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.helper.FindHelper;
import ch.inftec.ju.util.helper.FindNoneHelper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;

public class FindHelperBuilder<T> {
    private Collection<? extends T> collection;
    private T noneObject;

    public FindHelperBuilder<T> collection(Collection<? extends T> coll) {
        this.collection = coll;
        return this;
    }

    public <S> FindHelperBuilder<T> collectionTransformed(Collection<S> srcColl, Function<? super S, ? extends T> transformer) {
        return this.collection(Collections2.transform(srcColl, transformer));
    }

    public FindHelperBuilder<T> noneObject(T noneObject) {
        this.noneObject = noneObject;
        return this;
    }

    public FindHelper<T> createFindHelper() {
        AssertUtil.assertNotNull("Collection must be specified", this.collection);
        return new FindHelper<T>(this.collection);
    }

    public FindNoneHelper<T> createFindNoneHelper() {
        AssertUtil.assertNotNull("Collection must be specified", this.collection);
        AssertUtil.assertNotNull("None Object must be specified", this.noneObject);
        return new FindNoneHelper<T>(this.collection, this.noneObject);
    }
}

