/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.ReflectUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;

public class SystemPropertyTempSetter
implements AutoCloseable,
Serializable {
    private final Map<String, String> originalValues = new HashMap<String, String>();
    private EnvMaps origEnvs;

    public void setProperty(String key, String value) {
        if (!this.originalValues.containsKey(key)) {
            this.originalValues.put(key, System.getProperty(key));
        }
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    public void setEnv(String key, String value) {
        EnvMaps maps = this.getEnvMaps();
        if (this.origEnvs == null) {
            this.origEnvs = new EnvMaps();
            this.origEnvs.env = new HashMap(maps.env);
            if (maps.envCaseInsensitive != null) {
                this.origEnvs.envCaseInsensitive = new HashMap(maps.envCaseInsensitive);
            }
        }
        maps.put(key, value);
        this.resetEnvarBasedValueSourceCache();
    }

    private void resetEnvarBasedValueSourceCache() {
        ReflectUtils.setStaticField(EnvarBasedValueSource.class, "envarsCaseSensitive", null, true);
        ReflectUtils.setStaticField(EnvarBasedValueSource.class, "envarsCaseInsensitive", null, true);
    }

    private EnvMaps getEnvMaps() {
        EnvMaps envMaps = new EnvMaps();
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            envMaps.env = (Map)theEnvironmentField.get(null);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            envMaps.envCaseInsensitive = (Map)theCaseInsensitiveEnvironmentField.get(null);
        }
        catch (NoSuchFieldException e) {
            try {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    envMaps.env = (Map)obj;
                }
            }
            catch (Exception e2) {
                throw new JuRuntimeException(e2);
            }
        }
        catch (Exception e1) {
            throw new JuRuntimeException(e1);
        }
        return envMaps;
    }

    @Override
    public void close() {
        for (String key : this.originalValues.keySet()) {
            String value = this.originalValues.get(key);
            if (value == null) {
                System.clearProperty(key);
                continue;
            }
            System.setProperty(key, value);
        }
        if (this.origEnvs != null) {
            this.getEnvMaps().reset(this.origEnvs);
        }
    }

    private static final class EnvMaps {
        private Map<String, String> env;
        private Map<String, String> envCaseInsensitive;

        private EnvMaps() {
        }

        public void put(String key, String value) {
            if (value == null) {
                this.env.remove(key);
                if (this.envCaseInsensitive != null) {
                    this.envCaseInsensitive.remove(key);
                }
            } else {
                this.env.put(key, value);
                if (this.envCaseInsensitive != null) {
                    this.envCaseInsensitive.put(key, value);
                }
            }
        }

        public void reset(EnvMaps origMaps) {
            this.env.clear();
            this.env.putAll(origMaps.env);
            if (origMaps.envCaseInsensitive != null) {
                this.envCaseInsensitive.clear();
                this.envCaseInsensitive.putAll(origMaps.envCaseInsensitive);
            }
        }
    }
}

