/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.JuRuntimeException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class ReflectUtils {
    private ReflectUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static Class<?> getInnerClass(Class<?> clazz, String innerClassName) {
        for (Class<?> innerClass : clazz.getClasses()) {
            if (!innerClass.getSimpleName().equals(innerClassName)) continue;
            return innerClass;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ReflectUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ReflectUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static Class<?> getCallingClass() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            return Class.forName(stackTrace[3].getClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Couldn't get calling class", ex);
        }
    }

    public static Class<?>[] getTypes(Object[] objs) {
        ArrayList<Class<Object>> types = new ArrayList<Class<Object>>();
        for (Object obj : objs) {
            types.add(obj == null ? Object.class : obj.getClass());
        }
        return types.toArray(new Class[0]);
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        try {
            Method method = clazz.getMethod(name, paramTypes);
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        try {
            return clazz.getDeclaredMethod(name, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(name) || m.getParameterTypes().length != paramTypes.length) continue;
                boolean mismatch = false;
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (m.getParameterTypes()[i].isAssignableFrom(paramTypes[i])) continue;
                    mismatch = true;
                    break;
                }
                if (mismatch) continue;
                return m;
            }
            return null;
        }
    }

    public static Object getStaticFieldValue(Class<?> clazz, String fieldName, Object defaultValue) {
        try {
            Object fieldValue = FieldUtils.readStaticField(clazz, (String)fieldName, (boolean)true);
            return fieldValue != null ? fieldValue : defaultValue;
        }
        catch (IllegalArgumentException ex) {
            return defaultValue;
        }
        catch (Exception ex) {
            throw new JuRuntimeException(String.format("Couldn't read static field %s from class %s", fieldName, clazz), ex);
        }
    }

    public static Object getFieldValue(Object obj, Field field) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't access field", ex);
        }
    }

    public static <T> T newInstance(Class<T> clazz, boolean forceAccess, Object ... parameters) {
        try {
            if (!forceAccess && parameters.length == 0) {
                return clazz.newInstance();
            }
            Class[] parameterTypes = new Class[parameters.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                AssertUtil.assertNotNull("Null parameters not supported yet", parameters[i]);
                parameterTypes[i] = parameters[i].getClass();
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            if (forceAccess) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(parameters);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't create instance using default constructor for class " + clazz, ex);
        }
    }

    public static List<Method> getDeclaredMethodsByAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        TreeMap<String, Method> methods = new TreeMap<String, Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            Annotation a = method.getAnnotation(annotationClass);
            if (a == null) continue;
            methods.put(method.getName(), method);
        }
        return new ArrayList<Method>(methods.values());
    }

    public static List<Field> getDeclaredFieldsByAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        TreeMap<String, Field> fields = new TreeMap<String, Field>();
        for (Field field : clazz.getDeclaredFields()) {
            Annotation a = field.getAnnotation(annotationClass);
            if (a == null) continue;
            fields.put(field.getName(), field);
        }
        return new ArrayList<Field>(fields.values());
    }

    public static void setStaticField(Class<?> clazz, String fieldName, Object val, boolean force) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            if (force && !field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(null, val);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't set static field %s.%s to value %s", (Throwable)ex, clazz, fieldName, val);
        }
    }

    public static Object getDeclaredFieldValueByAnnotation(Object obj, Class<? extends Annotation> annotationClass, boolean forceAccess) {
        List<Field> fields = ReflectUtils.getDeclaredFieldsByAnnotation(obj.getClass(), annotationClass);
        if (fields.isEmpty()) {
            return null;
        }
        Field field = fields.get(0);
        try {
            if (forceAccess) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (IllegalAccessException ex) {
            throw new JuRuntimeException("Couldn't access field " + field.getName(), ex);
        }
    }

    private static <A extends Annotation> List<A> toAnnotationList(List<AnnotationInfo<A>> list) {
        ArrayList<A> annos = new ArrayList<A>();
        for (AnnotationInfo<A> annoInfo : list) {
            annos.add(annoInfo.getAnnotation());
        }
        return annos;
    }

    public static <A extends Annotation> List<A> getAnnotations(Class<?> clazz, Class<A> annotationClass, boolean includeSuperClassesAnnotations) {
        return ReflectUtils.toAnnotationList(ReflectUtils.getAnnotationsWithInfo(clazz, annotationClass, includeSuperClassesAnnotations));
    }

    public static <A extends Annotation> List<AnnotationInfo<A>> getAnnotationsWithInfo(Class<?> clazz, Class<A> annotationClass, boolean includeSuperClassesAnnotations) {
        ArrayList<AnnotationInfo<A>> annos = new ArrayList<AnnotationInfo<A>>();
        Class<?> c = clazz;
        do {
            A anno;
            if ((anno = c.getAnnotation(annotationClass)) != null) {
                annos.add(new AnnotationInfo((Annotation)anno, annotationClass, c, null, null));
            }
            c = c.getSuperclass();
        } while (includeSuperClassesAnnotations && c != null);
        return annos;
    }

    public static <A extends Annotation> List<A> getAnnotations(Method method, Class<A> annotationClass, boolean includeOverriddenMethods, boolean includeClassAnnotations, boolean includeSuperClassesAnnotations) {
        return ReflectUtils.toAnnotationList(ReflectUtils.getAnnotationsWithInfo(method, annotationClass, includeOverriddenMethods, includeClassAnnotations, includeSuperClassesAnnotations));
    }

    public static <A extends Annotation> List<AnnotationInfo<A>> getAnnotationsWithInfo(Method method, Class<A> annotationClass, boolean includeOverriddenMethods, boolean includeClassAnnotations, boolean includeSuperClassesAnnotations) {
        ArrayList<AnnotationInfo<A>> annos = new ArrayList<AnnotationInfo<A>>();
        Method m = method;
        do {
            Class<?> superClass;
            A anno;
            if ((anno = m.getAnnotation(annotationClass)) != null) {
                annos.add(new AnnotationInfo((Annotation)anno, annotationClass, m.getDeclaringClass(), m, null));
            }
            if ((superClass = m.getDeclaringClass().getSuperclass()) != null) {
                try {
                    m = superClass.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException ex) {
                    m = null;
                }
                continue;
            }
            m = null;
        } while (includeOverriddenMethods && m != null);
        if (includeClassAnnotations) {
            List<AnnotationInfo<A>> classAnnos = ReflectUtils.getAnnotationsWithInfo(method.getDeclaringClass(), annotationClass, includeSuperClassesAnnotations);
            annos.addAll(classAnnos);
        }
        return annos;
    }

    static class 1 {
    }

    public static class AnnotationInfo<A extends Annotation>
    implements Serializable {
        private A annotation;
        private String annotationClassName;
        private String className;
        private String methodName;

        private AnnotationInfo(A annotation, Class<A> annotationClass, Class<?> clazz, Method method) {
            this.annotation = annotation;
            this.annotationClassName = annotationClass.getName();
            this.className = clazz.getName();
            this.methodName = method == null ? null : method.getName();
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public String getDeclaringClassName() {
            return this.className;
        }

        public String getDeclaringMethodName() {
            return this.methodName;
        }

        public String toString() {
            String s = String.format("%s (%s", this.annotationClassName, this.className);
            s = this.methodName == null ? s + ")" : s + String.format(".%s())", this.methodName);
            return s;
        }

        /* synthetic */ AnnotationInfo(Annotation x0, Class x1, Class x2, Method x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }
}

