/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.RegexUtil;
import ch.inftec.ju.util.helper.FindHelperBuilder;
import ch.inftec.ju.util.helper.FindNoneHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestUtils {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    public static ManifestFinder find() {
        return new ManifestFinder();
    }

    public static final class ManifestFinder {
        private Map<URL, Manifest> manifests = new LinkedHashMap<URL, Manifest>();

        private ManifestFinder() {
            List<URL> manifests = JuUrl.resource().getAll(ManifestUtils.MANIFEST_PATH);
            try {
                for (URL manifestUrl : manifests) {
                    Manifest manifest = IOUtil.loadManifestFromUrl(manifestUrl);
                    this.manifests.put(manifestUrl, manifest);
                }
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't load manifests", ex);
            }
        }

        public ManifestFinder byAttribute(final String attributeName, String valueRegex) {
            final RegexUtil ru = new RegexUtil(valueRegex);
            this.filterManifests(new Predicate<Map.Entry<URL, Manifest>>(){

                public boolean apply(Map.Entry<URL, Manifest> e) {
                    Attributes attrs = e.getValue().getMainAttributes();
                    String val = attrs.getValue(attributeName);
                    return ru.matches(val);
                }
            });
            return this;
        }

        public ManifestFinder byJar(String jarFileRegex) {
            final RegexUtil ru = new RegexUtil(jarFileRegex);
            final RegexUtil jarNamePattern = new RegexUtil(".*/([^/]*.\\.jar)!.*");
            this.filterManifests(new Predicate<Map.Entry<URL, Manifest>>(){

                public boolean apply(Map.Entry<URL, Manifest> e) {
                    String jarName;
                    String path;
                    URL url = e.getKey();
                    return "jar".equals(url.getProtocol()) && jarNamePattern.matches(path = url.getPath()) && ru.matches(jarName = jarNamePattern.getMatches(path)[0].getGroups()[0]);
                }
            });
            return this;
        }

        private void filterManifests(Predicate<Map.Entry<URL, Manifest>> keep) {
            Iterator<Map.Entry<URL, Manifest>> iterator = this.manifests.entrySet().iterator();
            while (iterator.hasNext()) {
                if (keep.apply(iterator.next())) continue;
                iterator.remove();
            }
        }

        public FindNoneHelper<ManifestWrapper> find() {
            return new FindHelperBuilder<ManifestWrapper>().collectionTransformed(this.manifests.values(), new Function<Manifest, ManifestWrapper>(){

                public ManifestWrapper apply(Manifest m) {
                    return new ManifestWrapper(m);
                }
            }).noneObject(new ManifestWrapper(null){

                @Override
                public String getValue(String attributeName) {
                    return null;
                }
            }).createFindNoneHelper();
        }

        public static class ManifestWrapper {
            private final Manifest manifest;

            public ManifestWrapper(Manifest manifest) {
                this.manifest = manifest;
            }

            public String getValue(String attributeName) {
                Attributes attrs = this.manifest.getMainAttributes();
                return attrs.getValue(attributeName);
            }
        }
    }
}

