/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.XString;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JuUrl {
    public static URL resource(String resourceName) {
        return JuUrl.resource().get(resourceName);
    }

    public static URL resourceRelativeTo(String resourceName, Class<?> relativeClass) {
        return JuUrl.resource().relativeTo(relativeClass).get(resourceName);
    }

    public static URL singleResource(String resourceName) {
        return JuUrl.resource().single().exceptionIfNone().get(resourceName);
    }

    public static URL toUrl(Path p) {
        try {
            return p.toUri().toURL();
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't convert path '%s' to URL", (Throwable)ex, p);
        }
    }

    public static Path toPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't convert URL %s to Path", (Throwable)ex, url);
        }
    }

    public static Path existingFile(String path) {
        return JuUrl.path().file().exists().get(path);
    }

    public static Path existingFolder(String path) {
        return JuUrl.path().directory().exists().get(path);
    }

    public static URL existingResource(String resourceName) {
        return JuUrl.resource().exceptionIfNone().get(resourceName);
    }

    public static PathUrlBuilder path() {
        return new PathUrlBuilder();
    }

    public static ResourceUrlBuilder resource() {
        return new ResourceUrlBuilder();
    }

    public static class ResourceUrlBuilder {
        private Class<?> relativeClass;
        private boolean single = false;
        private boolean exceptionIfNone = false;

        public ResourceUrlBuilder relativeTo(Class<?> clazz) {
            this.relativeClass = clazz;
            return this;
        }

        public ResourceUrlBuilder single() {
            this.single = true;
            return this;
        }

        public ResourceUrlBuilder exceptionIfNone() {
            this.exceptionIfNone = true;
            return this;
        }

        public ResourceUrlBuilder exceptionIfNone(boolean exceptionIfNone) {
            this.exceptionIfNone = exceptionIfNone;
            return this;
        }

        public List<URL> getAll(String resourceName) {
            try {
                Enumeration<URL> resourcesEnum = IOUtil.class.getClassLoader().getResources(resourceName);
                ArrayList<URL> resources = new ArrayList<URL>();
                while (resourcesEnum.hasMoreElements()) {
                    resources.add(resourcesEnum.nextElement());
                }
                return resources;
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't lookup resource " + resourceName, ex);
            }
        }

        public URL get(String resourceName) {
            URL url = null;
            if (this.relativeClass != null) {
                url = this.relativeClass.getResource(resourceName);
            } else {
                List<URL> urls = this.getAll(resourceName);
                if (this.single && urls.size() > 1) {
                    XString xs = new XString("Found more than 1 resource with name %s:", resourceName);
                    xs.increaseIndent();
                    for (URL u : urls) {
                        xs.addLine(u.toString());
                    }
                    throw new JuRuntimeException(xs.toString());
                }
                if (urls.size() > 0) {
                    url = urls.get(0);
                }
            }
            if (url == null && this.exceptionIfNone) {
                throw new JuRuntimeException("Resource not found: %s", resourceName);
            }
            return url;
        }
    }

    public static class PathUrlBuilder {
        private boolean file;
        private boolean directory;
        private boolean exists;
        private String relativeToFirst;
        private String[] relativeToMore = new String[0];

        public PathUrlBuilder file() {
            this.file = true;
            return this;
        }

        public PathUrlBuilder directory() {
            this.directory = true;
            return this;
        }

        public PathUrlBuilder exists() {
            this.exists = true;
            return this;
        }

        public PathUrlBuilder relativeTo(String first, String ... more) {
            this.relativeToFirst = first;
            this.relativeToMore = more;
            return this;
        }

        public Path get(String path) {
            Path p = null;
            if (StringUtils.isEmpty((CharSequence)this.relativeToFirst)) {
                p = Paths.get(path, new String[0]);
            } else {
                String[] moreString = Arrays.copyOf(this.relativeToMore, this.relativeToMore.length + 1);
                moreString[moreString.length - 1] = path;
                p = Paths.get(this.relativeToFirst, moreString);
            }
            if (this.exists && !Files.exists(p, new LinkOption[0])) {
                throw new JuRuntimeException("Path doesn't exist: %s (absolute: %s)", p, p.toAbsolutePath());
            }
            if (this.file && !Files.isRegularFile(p, new LinkOption[0])) {
                throw new JuRuntimeException("Path is not a file: %s (absolute: %s)", p, p.toAbsolutePath());
            }
            if (this.directory && !Files.isDirectory(p, new LinkOption[0])) {
                throw new JuRuntimeException("Path is not a directory: %s (absolute: %s)", p, p.toAbsolutePath());
            }
            return p;
        }

        public boolean isExistingFile(Path path) {
            return Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]);
        }

        public boolean isExistingDirectory(Path path) {
            return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
        }
    }
}

