/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.WeakReferenceIterable;
import ch.inftec.ju.util.comparison.DefaultComparator;
import ch.inftec.ju.util.comparison.EqualityTester;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.ListUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public final class JuCollectionUtils {
    private JuCollectionUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static <K, V> boolean mapEquals(Map<K, V> m1, Map<K, V> m2, EqualityTester<V> equalityTester) {
        if (m1 == null || m2 == null) {
            return m1 == m2;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        if (equalityTester == null) {
            equalityTester = new DefaultComparator<V>();
        }
        for (K k : m1.keySet()) {
            if (!m2.containsKey(k)) {
                return false;
            }
            if (equalityTester.equals(m1.get(k), m2.get(k))) continue;
            return false;
        }
        return true;
    }

    public static <K, V> boolean mapEquals(Map<K, V> m1, Map<K, V> m2) {
        return JuCollectionUtils.mapEquals(m1, m2, null);
    }

    public static <T> boolean collectionEquals(Collection<? extends T> c1, Collection<? extends T> c2) {
        return ListUtils.isEqualList(c1, c2);
    }

    public static <T> boolean collectionEqualsIgnoreOrder(List<T> c1, List<T> c2) {
        return ListUtils.intersection(JuCollectionUtils.asList(c1), JuCollectionUtils.asList(c2)).size() == c1.size();
    }

    @SafeVarargs
    public static <T> boolean collectionContains(Collection<T> cCollection, T ... values) {
        for (T val : values) {
            if (cCollection.contains(val)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static boolean collectionContainsIgnoreCase(Collection<String> cCollection, String ... values) {
        for (String val : values) {
            boolean containsVal = false;
            for (String colVal : cCollection) {
                if (!colVal.equalsIgnoreCase(val)) continue;
                containsVal = true;
                break;
            }
            if (containsVal) continue;
            return false;
        }
        return true;
    }

    public static HashMap<String, Object> stringMap(Object ... keyValuePairs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 1; i < keyValuePairs.length; i += 2) {
            Object obj = keyValuePairs[i - 1];
            String key = obj instanceof String ? (String)obj : obj.toString();
            map.put(key, keyValuePairs[i]);
        }
        return map;
    }

    @SafeVarargs
    public static <T> ArrayList<T> arrayList(T ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> unmodifiableList(T ... elements) {
        return Collections.unmodifiableList(JuCollectionUtils.arrayList(elements));
    }

    public static <T> Collection<T> emptyForNull(Collection<T> col) {
        List emptyList = Collections.EMPTY_LIST;
        return col == null ? emptyList : col;
    }

    public static boolean isSubsetOf(Object[] srcArray, Object[] dstArray) {
        if (dstArray == null || srcArray == null) {
            return dstArray == srcArray;
        }
        for (Object o : srcArray) {
            if (ArrayUtils.contains((Object[])dstArray, (Object)o)) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayEquals(Object[] a1, Object[] a2) {
        if (a1 == null || a2 == null) {
            return a1 == a2;
        }
        if (a1.length == a2.length) {
            for (int i = 0; i < a1.length; ++i) {
                if (ObjectUtils.equals((Object)a1[i], (Object)a2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Collection<String> selectStartingWith(Collection<String> inputCollection, String startString, final boolean caseSensitive) {
        final String startStringConv = startString == null ? null : (caseSensitive ? startString.toUpperCase() : startString);
        return CollectionUtils.select(inputCollection, (Predicate)new Predicate<String>(){

            public boolean evaluate(String object) {
                if (object == null || startStringConv == null) {
                    return object == startStringConv;
                }
                String str = caseSensitive ? object.toUpperCase() : object;
                return str.startsWith(startStringConv);
            }
        });
    }

    public static <T> List<T> asList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> ArrayList<T> asArrayList(Collection<T> collection) {
        if (collection instanceof ArrayList) {
            return (ArrayList)collection;
        }
        return new ArrayList<T>(collection);
    }

    @SafeVarargs
    public static <T> ArrayList<T> asArrayList(T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        for (T value : values) {
            list.add(value);
        }
        return list;
    }

    @SafeVarargs
    public static <T, S extends T> ArrayList<T> asTypedArrayList(Class<T> type, S ... values) {
        ArrayList<S> list = new ArrayList<S>();
        for (S value : values) {
            list.add(value);
        }
        return list;
    }

    public static <T> Set<T> asSortedSet(Collection<T> collection) {
        TreeSet<T> set = new TreeSet<T>(collection);
        return set;
    }

    public static <T> Set<T> asSameOrderSet(Collection<T> collection) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(collection);
        return set;
    }

    public static Set<String> getKeyStrings(Properties props) {
        TreeSet<String> set = new TreeSet<String>();
        for (Object key : props.keySet()) {
            if (key == null) continue;
            set.add(key.toString());
        }
        return set;
    }

    public static <E> WeakReferenceIterable<E> newWeakReferenceIterable() {
        return new WeakReferenceIterableImpl();
    }

    static final class WeakReferenceIterableImpl<E>
    implements WeakReferenceIterable<E> {
        private final List<ReferenceWrapper<E>> list = new ArrayList<ReferenceWrapper<E>>();
        private final ReferenceQueue<E> queue = new ReferenceQueue();
        private int listVersion = 0;

        private WeakReferenceIterableImpl() {
        }

        int getInternalListSize() {
            return this.list.size();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iter();
        }

        @Override
        public void add(E element) {
            this.list.add(new ReferenceWrapper<E>(element, false, this.queue, this.list));
            ++this.listVersion;
        }

        @Override
        public void addWeak(E element) {
            if (element == null) {
                throw new NullPointerException("Null cannot be weak referenced");
            }
            this.list.add(new ReferenceWrapper<E>(element, true, this.queue, this.list));
            ++this.listVersion;
        }

        @Override
        public void remove(E element) {
            Iterator<ReferenceWrapper<E>> iter = this.list.iterator();
            while (iter.hasNext()) {
                ReferenceWrapper<E> wrapper = iter.next();
                if (!ObjectUtils.equals(element, wrapper.get())) continue;
                iter.remove();
                break;
            }
            if (this.list.size() > 0) {
                ((ReferenceWrapper)this.list.get(0)).removeDeadReferences();
            }
            ++this.listVersion;
        }

        @Override
        public void clear() {
            this.list.clear();
            ++this.listVersion;
        }

        private final class Iter
        implements Iterator<E> {
            private int index = -1;
            private Integer nextIndex = null;
            private Integer removedIndex = null;
            private int lastListVersion = WeakReferenceIterableImpl.access$300(WeakReferenceIterableImpl.this);
            private E nextElement;

            private Iter() {
            }

            @Override
            public boolean hasNext() {
                this.checkConcurrentUpdate();
                if (this.nextIndex == null || this.index == this.nextIndex) {
                    for (int i = this.index + 1; i < WeakReferenceIterableImpl.this.list.size(); ++i) {
                        ReferenceWrapper wrapper = (ReferenceWrapper)WeakReferenceIterableImpl.this.list.get(i);
                        this.nextElement = wrapper.get();
                        if (this.nextElement == null && wrapper.weakRef != null) continue;
                        this.nextIndex = i;
                        return true;
                    }
                    this.nextIndex = -1;
                }
                return this.nextIndex >= 0;
            }

            @Override
            public E next() {
                this.checkConcurrentUpdate();
                if (this.nextIndex == null || this.index == this.nextIndex) {
                    this.hasNext();
                }
                if (this.nextIndex == -1) {
                    throw new NoSuchElementException("No more elements in Iterable");
                }
                this.index = this.nextIndex;
                return ((ReferenceWrapper)WeakReferenceIterableImpl.this.list.get(this.index)).get();
            }

            @Override
            public void remove() {
                this.checkConcurrentUpdate();
                if (this.removedIndex != null && this.removedIndex == this.index) {
                    throw new IllegalStateException("Element was already removed");
                }
                if (this.index < 0) {
                    throw new IllegalStateException("Next hasn't been called yet");
                }
                WeakReferenceIterableImpl.this.list.remove(this.index);
                --this.index;
                this.removedIndex = this.index;
                Iter iter = this;
                Integer n = iter.nextIndex;
                Integer n2 = iter.nextIndex = Integer.valueOf(iter.nextIndex - 1);
                this.lastListVersion = WeakReferenceIterableImpl.this.listVersion;
            }

            private void checkConcurrentUpdate() {
                if (this.lastListVersion != WeakReferenceIterableImpl.this.listVersion) {
                    throw new ConcurrentModificationException("WeakReferenceIterable has been modified oustide of Iterator");
                }
            }
        }

        private static final class ReferenceWrapper<T> {
            private final T strongRef;
            private final WeakReference<T> weakRef;
            private final ReferenceQueue<T> queue;
            private final List<ReferenceWrapper<T>> list;

            ReferenceWrapper(T ref, boolean weak, ReferenceQueue<T> queue, List<ReferenceWrapper<T>> list) {
                if (weak) {
                    this.weakRef = new WeakReference<T>(ref, queue);
                    this.strongRef = null;
                } else {
                    this.strongRef = ref;
                    this.weakRef = null;
                }
                this.queue = queue;
                this.list = list;
                this.removeDeadReferences();
            }

            public T get() {
                return this.weakRef != null ? this.weakRef.get() : this.strongRef;
            }

            private void removeDeadReferences() {
                Reference<T> ref;
                while ((ref = this.queue.poll()) != null) {
                    this.list.remove(ref);
                }
            }
        }
    }
}

