/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.RegexUtil;
import org.junit.Assert;
import org.junit.Test;

public class RegexTest {
    @Test
    public void toStringTest() {
        Assert.assertEquals((Object)new RegexUtil("a*b").toString(), (Object)"a*b");
        Assert.assertEquals((Object)new RegexUtil("abcdefg").toString(), (Object)"abcdefg");
    }

    @Test
    public void matches() {
        RegexUtil ru = new RegexUtil("a*b");
        Assert.assertFalse((boolean)ru.isCaseInsensitive());
        Assert.assertTrue((boolean)ru.matches("aaab"));
        Assert.assertFalse((boolean)ru.matches("aaaabc"));
        Assert.assertFalse((boolean)ru.matches("Aaab"));
        ru.setCaseInsensitive(true);
        Assert.assertTrue((boolean)ru.matches("Aaab"));
        Assert.assertFalse((boolean)ru.matches(null));
        Assert.assertFalse((boolean)ru.matches(""));
    }

    @Test
    public void containsMatch() {
        RegexUtil ru = new RegexUtil("a*b");
        Assert.assertTrue((boolean)ru.containsMatch("ccabcc"));
        Assert.assertTrue((boolean)ru.containsMatch("ab"));
        Assert.assertFalse((boolean)ru.containsMatch("ac"));
        Assert.assertFalse((boolean)ru.containsMatch(""));
        Assert.assertFalse((boolean)ru.containsMatch(null));
    }

    @Test
    public void getMatches() {
        RegexUtil ru = new RegexUtil("(a+)(b*)");
        RegexUtil.Match[] matches = ru.getMatches("aaabbcacabbb");
        Assert.assertEquals((long)matches.length, (long)3L);
        Assert.assertEquals((Object)matches[0].getFullMatch(), (Object)"aaabb");
        Assert.assertArrayEquals((Object[])matches[0].getGroups(), (Object[])new String[]{"aaa", "bb"});
        RegexUtil noGroup = new RegexUtil("a*");
        RegexUtil.Match[] noGroupMatches = noGroup.getMatches("aaaabbb");
        Assert.assertEquals((long)noGroupMatches.length, (long)1L);
        Assert.assertEquals((long)noGroupMatches[0].getGroups().length, (long)0L);
        RegexUtil oneGroup = new RegexUtil("(a*)");
        RegexUtil.Match[] oneGroupMatches = oneGroup.getMatches("aaaabbb");
        Assert.assertEquals((long)oneGroupMatches.length, (long)1L);
        Assert.assertArrayEquals((Object[])oneGroupMatches[0].getGroups(), (Object[])new String[]{"aaaa"});
        Assert.assertEquals((long)ru.getMatches("").length, (long)0L);
        Assert.assertEquals((long)ru.getMatches(null).length, (long)0L);
    }

    @Test
    public void getStringMatches() {
        RegexUtil ru = new RegexUtil("a*b");
        Assert.assertArrayEquals((Object[])ru.getStringMatches("aaabccabcaab"), (Object[])new String[]{"aaab", "ab", "aab"});
        RegexUtil ruEager = new RegexUtil("a*b*");
        Assert.assertArrayEquals((Object[])ruEager.getStringMatches("aaabbbcaabb"), (Object[])new String[]{"aaabbb", "aabb"});
        RegexUtil ruEmpty = new RegexUtil("a*");
        Assert.assertArrayEquals((Object[])ruEmpty.getStringMatches("bbbbbb"), (Object[])new String[]{""});
        RegexUtil ruSimple = new RegexUtil("a");
        Assert.assertArrayEquals((Object[])ruSimple.getStringMatches("aacaa"), (Object[])new String[]{"a", "a", "a", "a"});
        Assert.assertArrayEquals((Object[])ru.getStringMatches(""), (Object[])new String[0]);
        Assert.assertArrayEquals((Object[])ru.getStringMatches(null), (Object[])new String[0]);
    }

    @Test
    public void findsFirstMatchIndex_forMatch() {
        RegexUtil ru = new RegexUtil("a");
        Assert.assertEquals((long)0L, (long)ru.getFirstMatchIndex("abc"));
        Assert.assertEquals((long)1L, (long)ru.getFirstMatchIndex("babc"));
        Assert.assertEquals((long)2L, (long)ru.getFirstMatchIndex("bbaaa"));
    }

    @Test
    public void findsFirstMatchIndex_returnsMinusOne_forNonMatch() {
        RegexUtil ru = new RegexUtil("a");
        Assert.assertEquals((long)-1L, (long)ru.getFirstMatchIndex("bcd"));
        Assert.assertEquals((long)-1L, (long)ru.getFirstMatchIndex(null));
        Assert.assertEquals((long)-1L, (long)ru.getFirstMatchIndex(""));
    }
}

