/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.xml;

import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.xml.XPathGetter;
import ch.inftec.ju.util.xml.XmlBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlUtils {
    private XmlUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static Document loadXml(URL xmlUrl) throws JuException {
        return XmlUtils.loadXml(xmlUrl, null);
    }

    public static XPathGetter loadXmlAsXPathGetter(URL xmlUrl) throws JuException {
        return new XPathGetter(XmlUtils.loadXml(xmlUrl));
    }

    public static Document loadXml(URL xmlUrl, URL schemaUrl) throws JuException {
        Document document;
        BufferedInputStream xmlStream = null;
        try {
            xmlStream = new BufferedInputStream(xmlUrl.openStream());
            document = XmlUtils.loadXml(new InputSource(xmlStream), XmlUtils.loadSchema(schemaUrl));
        }
        catch (Exception ex) {
            try {
                throw new JuException(String.format("Couldn't load XML from URL: %s (Schema URL: %s)", xmlUrl, schemaUrl), ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(xmlStream);
                throw throwable;
            }
        }
        IOUtil.close(xmlStream);
        return document;
    }

    public static Document loadXml(InputStream inputStream, Schema schema) throws JuException {
        Document document;
        BufferedInputStream xmlStream = null;
        try {
            xmlStream = new BufferedInputStream(inputStream);
            document = XmlUtils.loadXml(new InputSource(xmlStream), schema);
        }
        catch (Exception ex) {
            try {
                throw new JuException("Couldn't load XML from InputStream", ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(xmlStream);
                throw throwable;
            }
        }
        IOUtil.close(xmlStream);
        return document;
    }

    public static Document loadXml(InputSource xmlSource, Schema schema) throws JuException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(xmlSource);
            XmlUtils.removeWhitespaceNodes(doc.getDocumentElement());
            if (schema != null) {
                schema.newValidator().validate(new DOMSource(doc));
            }
            return doc;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't load XML", ex);
        }
    }

    private static void removeWhitespaceNodes(Element e) {
        NodeList children = e.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof Text && ((Text)child).getData().trim().length() == 0) {
                e.removeChild(child);
            } else if (child instanceof Element) {
                XmlUtils.removeWhitespaceNodes((Element)child);
            }
            --i;
        }
    }

    public static Document loadXml(String xmlString, Schema schema) throws JuException {
        return XmlUtils.loadXml(new InputSource(new StringReader(xmlString)), schema);
    }

    public static Schema loadSchema(URL url) throws JuException {
        if (url == null) {
            return null;
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(url);
            return schema;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't load XML schema: " + url, ex);
        }
    }

    public static String indentXml(String xmlString, boolean includeXmlDeclaration) throws JuException {
        Document doc = XmlUtils.loadXml(xmlString, null);
        return XmlUtils.toString(doc, includeXmlDeclaration, true);
    }

    public static String toString(Document document, boolean includeXmlDeclaration, boolean indent) throws JuRuntimeException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", includeXmlDeclaration ? "no" : "yes");
            if (indent) {
                transformer.setOutputProperty("indent", indent ? "yes" : "no");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                transformer.transform(new DOMSource(document), new StreamResult(os));
                return new String(os.toByteArray(), "UTF-8");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't convert XML to String", ex);
        }
    }

    public static XmlBuilder buildXml(String rootElementName) {
        return XmlBuilder.createRootBuilder(rootElementName);
    }
}

