/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.persistable;

import ch.inftec.ju.util.persistable.MementoStorage;
import ch.inftec.ju.util.persistable.Persistable;
import ch.inftec.ju.util.persistable.PersistableManager;
import ch.inftec.ju.util.persistable.TypeHandler;

final class PersistableManagerImpl
implements PersistableManager {
    private MementoStorage storage;
    private TypeHandler typeHandler;

    public PersistableManagerImpl(MementoStorage storage, TypeHandler typeHandler) {
        this.storage = storage;
        this.typeHandler = typeHandler;
    }

    @Override
    public Long persist(Persistable obj) {
        String type = this.typeHandler.getTypeName(obj);
        return this.storage.persistMemento(obj.createMemento(), type);
    }

    @Override
    public Persistable load(Long id) {
        MementoStorage.GenericMementoItem mementoItem = this.storage.loadMemento(id);
        if (mementoItem != null) {
            Persistable persistable = this.typeHandler.newInstance(mementoItem.getType());
            persistable.setMemento(mementoItem.getMemento());
            return persistable;
        }
        return null;
    }
}

