/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.persistable;

import ch.inftec.ju.util.persistable.GenericMemento;
import ch.inftec.ju.util.persistable.GenericMementoUtils;
import ch.inftec.ju.util.persistable.MementoStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class MemoryMementoStorage
implements MementoStorage {
    private TreeMap<Long, GenericMemento> mementos = new TreeMap();
    private Map<Long, String> mementoTypes = new HashMap<Long, String>();

    MemoryMementoStorage() {
    }

    @Override
    public Long persistMemento(GenericMemento memento, String type) {
        long id = this.mementos.size() == 0 ? 0L : this.mementos.lastKey() + 1L;
        this.mementos.put(id, memento);
        if (type != null) {
            this.mementoTypes.put(id, type);
        }
        for (GenericMemento childMemento : memento.getChildren()) {
            this.persistMemento(childMemento, null);
        }
        return id;
    }

    @Override
    public MementoStorage.GenericMementoItem loadMemento(Long id) {
        if (id == null) {
            return null;
        }
        GenericMemento memento = this.mementos.get(id);
        if (memento == null) {
            return null;
        }
        return GenericMementoUtils.newGenericMementoItem(this.mementos.get(id), id, this.mementoTypes.get(id));
    }

    @Override
    public List<MementoStorage.GenericMementoItem> loadMementos(int maxCount) {
        ArrayList<MementoStorage.GenericMementoItem> list = new ArrayList<MementoStorage.GenericMementoItem>();
        Iterator<Long> i = this.mementos.descendingKeySet().iterator();
        while (list.size() < maxCount && i.hasNext()) {
            Long key = i.next();
            list.add(this.loadMemento(key));
        }
        return list;
    }
}

