/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.io;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;

public class NewLineReader
extends Reader {
    public static String LF = "\n";
    public static String CRLF = "\r\n";
    private String inputNewLine = null;
    private String outputNewLine = null;
    private Queue<Character> queue = new LinkedList<Character>();
    private Reader reader;

    public NewLineReader(Reader reader) {
        this(reader, null, null);
    }

    public NewLineReader(Reader reader, String inputNewLine, String outputNewLine) {
        this.reader = reader;
        if (StringUtils.length((CharSequence)inputNewLine) > 2 || StringUtils.length((CharSequence)outputNewLine) > 2) {
            throw new IllegalArgumentException("Input and Output NewLine characters can not be longer than 2 characters.");
        }
        if (inputNewLine != null && inputNewLine.length() == 0) {
            throw new IllegalArgumentException("Input NewLine may not be empty String");
        }
        this.inputNewLine = inputNewLine;
        this.outputNewLine = outputNewLine;
    }

    public String getInputNewLine() {
        return this.inputNewLine;
    }

    public String getOutputNewLine() {
        return this.outputNewLine;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i;
        this.doRead(len);
        if (this.queue.size() == 0) {
            return -1;
        }
        int lastIndex = off + len - 1;
        for (i = off; i <= lastIndex && this.queue.size() > 0; ++i) {
            cbuf[i] = this.queue.poll().charValue();
        }
        return i - off;
    }

    private void doRead(int len) throws IOException {
        while (this.queue.size() < len) {
            if (this.readFirstChar()) continue;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readFirstChar() throws IOException {
        int nextChInt = this.reader.read();
        if (nextChInt == -1) {
            return false;
        }
        char nextCh = (char)nextChInt;
        if (this.inputNewLine != null && this.inputNewLine.charAt(0) == nextCh) {
            if (this.inputNewLine.length() != 1) return this.readSecondChar(nextCh);
            this.addNewLine();
            return true;
        } else if (this.inputNewLine == null && nextCh == '\n') {
            this.inputNewLine = "\n";
            this.addNewLine();
            return true;
        } else {
            if (this.inputNewLine == null && nextCh == '\r') {
                return this.readSecondChar(nextCh);
            }
            this.queue.add(Character.valueOf(nextCh));
        }
        return true;
    }

    private boolean readSecondChar(char firstCh) throws IOException {
        int nextChInt = this.reader.read();
        if (nextChInt == -1) {
            if (this.inputNewLine == null && firstCh == '\r' || firstCh == '\n') {
                this.inputNewLine = Character.toString(firstCh);
                this.addNewLine();
            } else {
                this.queue.add(Character.valueOf(firstCh));
            }
            return false;
        }
        char nextCh = (char)nextChInt;
        if (this.inputNewLine != null) {
            if (this.inputNewLine.charAt(1) == nextCh) {
                this.addNewLine();
            } else {
                this.queue.add(Character.valueOf(firstCh));
                this.queue.add(Character.valueOf(nextCh));
            }
        } else if (nextCh == '\n') {
            this.inputNewLine = "\r\n";
            this.addNewLine();
        } else {
            this.inputNewLine = "\r";
            this.addNewLine();
            this.queue.add(Character.valueOf(nextCh));
        }
        return true;
    }

    private void addNewLine() {
        if (this.outputNewLine == null) {
            this.outputNewLine = this.inputNewLine;
        }
        for (int i = 0; i < this.outputNewLine.length(); ++i) {
            this.queue.add(Character.valueOf(this.outputNewLine.charAt(i)));
        }
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
        this.queue.clear();
    }

    public LineIterator iterateLines() {
        return new LineIterator((Reader)this);
    }
}

