/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.event;

import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.WeakReferenceIterable;
import ch.inftec.ju.util.event.EventNotifier;
import ch.inftec.ju.util.event.JuEventObject;
import ch.inftec.ju.util.event.UpdateListener;
import java.util.EventListener;
import org.junit.Assert;

public final class JuEventUtils {
    public static <T> UpdateEventNotifier<T> newUpdateEventNotifier() {
        return new UpdateEventNotifier();
    }

    public static <T> TestUpdateListener<T> newTestUpdateListener() {
        return new TestUpdateListener();
    }

    public static <T1, T2> Object forwardUpdateEvents(EventNotifier<UpdateListener<T1>> sourceNotifier, UpdateEventNotifier<T2> targetNotifier, T2 forwardingSource, boolean strongReference) {
        ForwardingUpdateListener forwardingListener = new ForwardingUpdateListener(targetNotifier, forwardingSource);
        if (strongReference) {
            sourceNotifier.addListener(forwardingListener);
        } else {
            sourceNotifier.addWeakListener(forwardingListener);
        }
        return forwardingListener;
    }

    public static class TestUpdateListener<T>
    implements UpdateListener<T> {
        private int calls = 0;
        private JuEventObject<T> lastEventObject;

        private TestUpdateListener() {
        }

        @Override
        public void updated(JuEventObject<T> event) {
            ++this.calls;
            this.lastEventObject = event;
        }

        public int getCalls() {
            return this.calls;
        }

        public int resetCalls() {
            int currentCalls = this.calls;
            this.calls = 0;
            return currentCalls;
        }

        public T assertCall() {
            if (this.calls == 0) {
                Assert.fail((String)"Update event wasn't called");
            }
            this.calls = 0;
            return this.getLastSource();
        }

        public T assertOneCall() {
            if (this.calls != 1) {
                Assert.fail((String)("Update event wasn't called exactly once, but " + this.calls + "times."));
            }
            this.calls = 0;
            return this.getLastSource();
        }

        public void assertNoCall() {
            if (this.calls > 0) {
                Assert.fail((String)("Update event was called. Times: " + this.calls));
            }
        }

        public JuEventObject<T> getLastEventObject() {
            return this.lastEventObject;
        }

        public T getLastSource() {
            return this.getLastEventObject() == null ? null : (T)this.getLastEventObject().getSource();
        }
    }

    public static class UpdateEventNotifier<T>
    extends AbstractEventNotifier<UpdateListener<T>> {
        protected UpdateEventNotifier() {
        }

        public void fireUpdateEvent(T sender) {
            JuEventObject<T> o = new JuEventObject<T>(sender);
            for (UpdateListener listener : this.getListeners()) {
                listener.updated(o);
            }
        }
    }

    public static abstract class AbstractEventNotifier<T extends EventListener>
    implements EventNotifier<T> {
        private final WeakReferenceIterable<T> listeners = JuCollectionUtils.newWeakReferenceIterable();

        @Override
        public final void addListener(T listener) {
            this.listeners.add(listener);
        }

        @Override
        public final void addWeakListener(T listener) {
            this.listeners.addWeak(listener);
        }

        @Override
        public final void removeListener(T listener) {
            this.listeners.remove(listener);
        }

        protected final Iterable<T> getListeners() {
            return this.listeners;
        }
    }

    private static class ForwardingUpdateListener<T1, T2>
    implements UpdateListener<T1> {
        private final UpdateEventNotifier<T2> targetNotifier;
        private final T2 forwardingSource;

        ForwardingUpdateListener(UpdateEventNotifier<T2> targetNotifier, T2 forwardingSource) {
            this.targetNotifier = targetNotifier;
            this.forwardingSource = forwardingSource;
        }

        @Override
        public void updated(JuEventObject<T1> event) {
            this.targetNotifier.fireUpdateEvent(this.forwardingSource);
        }
    }
}

