/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.context;

import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.context.GenericContext;
import ch.inftec.ju.util.context.GenericContextX;
import ch.inftec.ju.util.context.ObjectEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GenericContextUtils {
    private GenericContextUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static GenericContextBuilder builder() {
        return new GenericContextBuilder();
    }

    public static GenericContextX asX(GenericContext context) {
        if (context instanceof GenericContextX) {
            return (GenericContextX)context;
        }
        return new GenericContextX(context);
    }

    public static class GenericContextBuilder {
        private GenericContextImpl genericContext = new GenericContextImpl();

        private GenericContextBuilder() {
        }

        public <T> GenericContextBuilder setObject(Class<T> clazz, T obj) {
            this.genericContext.setObject(clazz, obj);
            return this;
        }

        @SafeVarargs
        public final <T> GenericContextBuilder addObjects(Class<T> clazz, T ... objs) {
            this.genericContext.addObjects(clazz, objs);
            return this;
        }

        public <T> GenericContextBuilder setObjectEvaluator(Class<T> clazz, ObjectEvaluator<T> evaluator) {
            this.genericContext.setObjectEvaluator(clazz, evaluator);
            return this;
        }

        public GenericContext build() {
            return this.genericContext;
        }
    }

    private static final class GenericContextImpl
    implements GenericContext {
        HashMap<Class<?>, ArrayList<Object>> objects = new HashMap();
        HashMap<Class<?>, ObjectEvaluator<?>> evaluators = new HashMap();

        private GenericContextImpl() {
        }

        @Override
        public <T> List<T> getObjects(Class<T> clazz) {
            return Collections.unmodifiableList(this.getList(clazz));
        }

        @SafeVarargs
        public final <T> void addObjects(Class<T> clazz, T ... objs) {
            ArrayList<T> list = this.getList(clazz);
            for (T obj : objs) {
                list.add(obj);
            }
        }

        <T> void clearObjects(Class<T> clazz) {
            this.objects.remove(clazz);
        }

        <T> void setObject(Class<T> clazz, T obj) {
            this.clearObjects(clazz);
            this.addObjects(clazz, obj);
        }

        <T> ArrayList<T> getList(Class<T> clazz) {
            if (!this.objects.containsKey(clazz)) {
                this.objects.put(clazz, new ArrayList());
            }
            ArrayList<Object> list = this.objects.get(clazz);
            return list;
        }

        @Override
        public <T> List<T> getObjects(Class<T> clazz, Map<String, Object> map) {
            ObjectEvaluator<T> evaluator = this.getEvaluator(clazz);
            return evaluator != null ? evaluator.getObjects(map) : Collections.unmodifiableList(new ArrayList());
        }

        <T> void setObjectEvaluator(Class<T> clazz, ObjectEvaluator<T> evaluator) {
            this.evaluators.put(clazz, evaluator);
        }

        <T> ObjectEvaluator<T> getEvaluator(Class<T> clazz) {
            ObjectEvaluator<?> evaluator = this.evaluators.get(clazz);
            return evaluator;
        }

        public String toString() {
            return JuStringUtils.toString(this, "objects", this.objects, "evaluators", this.evaluators);
        }
    }
}

