/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import java.util.HashMap;
import java.util.Map;

public class SystemPropertyTempSetter
implements AutoCloseable {
    private final Map<String, String> originalValues = new HashMap<String, String>();

    public void setProperty(String key, String value) {
        if (!this.originalValues.containsKey(key)) {
            this.originalValues.put(key, System.getProperty(key));
        }
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    @Override
    public void close() {
        for (String key : this.originalValues.keySet()) {
            String value = this.originalValues.get(key);
            if (value == null) {
                System.clearProperty(key);
                continue;
            }
            System.setProperty(key, value);
        }
    }
}

