/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.JuRuntimeException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class ReflectUtils {
    private ReflectUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static Class<?> getInnerClass(Class<?> clazz, String innerClassName) {
        Class<?>[] classArray = clazz.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> innerClass = classArray[n2];
            if (innerClass.getSimpleName().equals(innerClassName)) {
                return innerClass;
            }
            ++n2;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ReflectUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            int i = 0;
            while (i < actualTypeArguments.length) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
                ++i;
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        Type[] typeArray = actualTypeArguments;
        int n = actualTypeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            Type baseType = typeArray[n2];
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ReflectUtils.getClass(baseType));
            ++n2;
        }
        return typeArgumentsAsClasses;
    }

    public static Class<?> getCallingClass() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            return Class.forName(stackTrace[3].getClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Couldn't get calling class", ex);
        }
    }

    public static Class<?>[] getTypes(Object[] objs) {
        ArrayList<Class<Object>> types = new ArrayList<Class<Object>>();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            types.add(obj == null ? Object.class : obj.getClass());
            ++n2;
        }
        return types.toArray(new Class[0]);
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        try {
            Method method = clazz.getMethod(name, paramTypes);
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        try {
            return clazz.getDeclaredMethod(name, paramTypes);
        }
        catch (NoSuchMethodException var3_3) {
            var6_5 = clazz.getDeclaredMethods();
            var5_6 = var6_5.length;
            var4_7 = 0;
            ** while (var4_7 < var5_6)
        }
lbl-1000:
        // 1 sources

        {
            m = var6_5[var4_7];
            if (m.getName().equals(name) && m.getParameterTypes().length == paramTypes.length) {
                mismatch = false;
                i = 0;
                while (i < paramTypes.length) {
                    if (!m.getParameterTypes()[i].isAssignableFrom(paramTypes[i])) {
                        mismatch = true;
                        break;
                    }
                    ++i;
                }
                if (!mismatch) {
                    return m;
                }
            }
            ++var4_7;
            continue;
        }
lbl22:
        // 1 sources

        return null;
    }

    public static Object getStaticFieldValue(Class<?> clazz, String fieldName, Object defaultValue) {
        try {
            Object fieldValue = FieldUtils.readStaticField(clazz, (String)fieldName, (boolean)true);
            return fieldValue != null ? fieldValue : defaultValue;
        }
        catch (IllegalArgumentException ex) {
            return defaultValue;
        }
        catch (Exception ex) {
            throw new JuRuntimeException(String.format("Couldn't read static field %s from class %s", fieldName, clazz), ex);
        }
    }

    public static Object getFieldValue(Object obj, Field field) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't access field", ex);
        }
    }

    public static <T> T newInstance(Class<T> clazz, boolean forceAccess, Object ... parameters) {
        try {
            if (!forceAccess && parameters.length == 0) {
                return clazz.newInstance();
            }
            Class[] parameterTypes = new Class[parameters.length];
            int i = 0;
            while (i < parameterTypes.length) {
                AssertUtil.assertNotNull("Null parameters not supported yet", parameters[i]);
                parameterTypes[i] = parameters[i].getClass();
                ++i;
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            if (forceAccess) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(parameters);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't create instance using default constructor for class " + clazz, ex);
        }
    }

    public static List<Field> getDeclaredFieldsByAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        TreeMap<String, Field> fields = new TreeMap<String, Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Annotation a = field.getAnnotation(annotationClass);
            if (a != null) {
                fields.put(field.getName(), field);
            }
            ++n2;
        }
        return new ArrayList<Field>(fields.values());
    }

    public static Object getDeclaredFieldValueByAnnotation(Object obj, Class<? extends Annotation> annotationClass, boolean forceAccess) {
        List<Field> fields = ReflectUtils.getDeclaredFieldsByAnnotation(obj.getClass(), annotationClass);
        if (fields.isEmpty()) {
            return null;
        }
        Field field = fields.get(0);
        try {
            if (forceAccess) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (IllegalAccessException ex) {
            throw new JuRuntimeException("Couldn't access field " + field.getName(), ex);
        }
    }

    public static <A extends Annotation> List<A> getAnnotations(Class<?> clazz, Class<A> annotationClass, boolean includeSuperClassesAnnotations) {
        ArrayList<A> annos = new ArrayList<A>();
        Class<?> c = clazz;
        do {
            A anno;
            if ((anno = c.getAnnotation(annotationClass)) != null) {
                annos.add(anno);
            }
            c = c.getSuperclass();
        } while (includeSuperClassesAnnotations && c != null);
        return annos;
    }

    public static <A extends Annotation> List<A> getAnnotations(Method method, Class<A> annotationClass, boolean includeOverriddenMethods, boolean includeClassAnnotations, boolean includeSuperClassesAnnotations) {
        ArrayList<A> annos = new ArrayList<A>();
        Method m = method;
        do {
            Class<?> superClass;
            A anno;
            if ((anno = m.getAnnotation(annotationClass)) != null) {
                annos.add(anno);
            }
            if ((superClass = m.getDeclaringClass().getSuperclass()) != null) {
                try {
                    m = superClass.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException ex) {
                    m = null;
                }
                continue;
            }
            m = null;
        } while (includeOverriddenMethods && m != null);
        if (includeClassAnnotations) {
            List<A> classAnnos = ReflectUtils.getAnnotations(method.getDeclaringClass(), annotationClass, includeSuperClassesAnnotations);
            annos.addAll(classAnnos);
        }
        return annos;
    }
}

