/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.CsvTableLookup;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.PropertyEvaluator;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyChainBuilder {
    private Logger logger = LoggerFactory.getLogger(PropertyChainBuilder.class);
    private final List<PropertyEvaluator> evaluators = new ArrayList<PropertyEvaluator>();
    private boolean defaultThrowExceptionIfUndefined = false;

    public PropertyChainBuilder addSystemPropertyEvaluator() {
        return this.addPropertyEvaluator(new SystemPropertyEvaluator());
    }

    public PropertyChainBuilder addResourcePropertyEvaluator(URL resourceUrl) {
        try {
            return this.addPropertyEvaluator(new PropertiesPropertyEvaluator(resourceUrl));
        }
        catch (JuException ex) {
            throw new JuRuntimeException("Couldn't load properties from url " + resourceUrl, ex);
        }
    }

    public PropertyChainBuilder addResourcePropertyEvaluator(String resourceName, boolean ignoreMissingResource) {
        try {
            URL resourceUrl = JuUrl.resource(resourceName);
            return this.addPropertyEvaluator(new PropertiesPropertyEvaluator(resourceUrl));
        }
        catch (JuException ex) {
            if (ignoreMissingResource) {
                this.logger.debug(String.format("Ignoring missing resource %s (Exception: %s)", resourceName, ex.getMessage()));
                return this;
            }
            throw new JuRuntimeException("Couldn't load properties from resource " + resourceName, ex);
        }
    }

    public PropertyChainBuilder addCsvPropertyEvaluator(URL resourceUrl, String profileName, String defaultColumnName) {
        CsvPropertyEvaluator csvEvaluator = new CsvPropertyEvaluator(resourceUrl, profileName, defaultColumnName);
        return this.addPropertyEvaluator(csvEvaluator);
    }

    public PropertyChainBuilder addPropertyEvaluator(PropertyEvaluator evaluator) {
        this.evaluators.add(evaluator);
        return this;
    }

    public PropertyChainBuilder setDefaultThrowExceptionIfUndefined(boolean defaultThrowExceptionIfUndefined) {
        this.defaultThrowExceptionIfUndefined = defaultThrowExceptionIfUndefined;
        return this;
    }

    public PropertyChain getPropertyChain() {
        return new PropertyChainImpl();
    }

    private static class CsvPropertyEvaluator
    implements PropertyEvaluator {
        private final URL resourceUrl;
        private final String profile;
        private final CsvTableLookup csvTable;

        public CsvPropertyEvaluator(URL resourceUrl, String profile, String defaultColumn) {
            this.resourceUrl = resourceUrl;
            this.profile = profile;
            this.csvTable = CsvTableLookup.build().from(resourceUrl).defaultColumn(defaultColumn).create();
        }

        @Override
        public Object get(String key) {
            return this.csvTable.get(key, this.profile);
        }

        public String toString() {
            return JuStringUtils.toString(this, "url", this.resourceUrl, "profile", this.profile);
        }
    }

    private static class PropertiesPropertyEvaluator
    implements PropertyEvaluator {
        private final URL propertiesUrl;
        private final Properties props;

        public PropertiesPropertyEvaluator(URL propertiesUrl) throws JuException {
            this.propertiesUrl = propertiesUrl;
            this.props = new IOUtil().loadPropertiesFromUrl(propertiesUrl);
        }

        @Override
        public Object get(String key) {
            return this.props.get(key);
        }

        public String toString() {
            return JuStringUtils.toString(this, "url", this.propertiesUrl);
        }
    }

    private class PropertyChainImpl
    implements PropertyChain {
        private PropertyChainImpl() {
        }

        @Override
        public String get(String key) {
            return this.get(key, PropertyChainBuilder.this.defaultThrowExceptionIfUndefined);
        }

        @Override
        public String get(String key, boolean throwExceptionIfNotDefined) {
            Object obj = this.getObject(key, null, throwExceptionIfNotDefined);
            return obj == null ? null : obj.toString();
        }

        @Override
        public String get(String key, String defaultValue) {
            String val = this.get(key, false);
            return val != null ? val : defaultValue;
        }

        @Override
        public <T> T get(String key, Class<T> clazz) {
            String val = this.get(key);
            return this.convert(val, clazz);
        }

        @Override
        public <T> T get(String key, Class<T> clazz, boolean throwExceptionIfNotDefined) {
            String val = this.get(key, throwExceptionIfNotDefined);
            return this.convert(val, clazz);
        }

        @Override
        public <T> T get(String key, Class<T> clazz, String defaultValue) {
            String val = this.get(key, defaultValue);
            return this.convert(val, clazz);
        }

        private <T> T convert(String val, Class<T> clazz) {
            if (StringUtils.isEmpty((CharSequence)val)) {
                return null;
            }
            if (clazz == Integer.class) {
                return (T)new Integer(val);
            }
            if (clazz == Boolean.class) {
                return (T)new Boolean(val);
            }
            throw new JuRuntimeException("Conversion not supported: " + clazz);
        }

        private Object getObject(String key, Object defaultValue, boolean throwExceptionIfNotDefined) {
            Object obj = this.evaluate(key);
            if (obj == null) {
                if (throwExceptionIfNotDefined) {
                    throw new JuRuntimeException("Property undefined: " + key);
                }
                return defaultValue;
            }
            return obj;
        }

        private Object evaluate(String key) {
            for (PropertyEvaluator evaluator : PropertyChainBuilder.this.evaluators) {
                Object val = evaluator.get(key);
                if (val == null) continue;
                PropertyChainBuilder.this.logger.debug("Evaluated property {}={} [using {}]", new Object[]{key, val, evaluator.toString()});
                return val;
            }
            return null;
        }
    }

    private static class SystemPropertyEvaluator
    implements PropertyEvaluator {
        private SystemPropertyEvaluator() {
        }

        @Override
        public Object get(String key) {
            return System.getProperty(key);
        }

        public String toString() {
            return JuStringUtils.toString(this, new Object[0]);
        }
    }
}

