/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.PropertyChainBuilder;
import ch.inftec.ju.util.XString;
import java.io.BufferedReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuUtils {
    private static Logger logger = LoggerFactory.getLogger(JuUtils.class);
    private static PropertyChain juPropertyChain;
    private static String PROPERTIES_FILES_NAME;

    static {
        PROPERTIES_FILES_NAME = "ju.properties.files";
    }

    public static PropertyChain getJuPropertyChain() {
        if (juPropertyChain == null) {
            Object object;
            logger.debug("Initializing JU PropertyChain");
            List<URL> propFiles = JuUrl.resource().getAll(PROPERTIES_FILES_NAME);
            XString duplicatePrios = new XString();
            TreeMap<Integer, String[]> props = new TreeMap<Integer, String[]>();
            for (URL propFile : propFiles) {
                logger.debug("Processing property file: " + propFile);
                XString filteredContents = new XString("Filtered contents: ");
                filteredContents.increaseIndent();
                try {
                    object = null;
                    Object var7_10 = null;
                    try (BufferedReader r = new IOUtil().createReader(propFile);){
                        String line = r.readLine();
                        while (line != null) {
                            String[] lineParts = JuStringUtils.split(line, ",", true);
                            if (lineParts.length > 0 && !lineParts[0].startsWith("#")) {
                                AssertUtil.assertTrue("Invalid line: " + line, lineParts.length > 1);
                                filteredContents.addLine(line);
                                int priorization = Integer.parseInt(lineParts[0]);
                                if (props.containsKey(priorization)) {
                                    duplicatePrios.addLineFormatted("Duplicate priorization in %s: %d", PROPERTIES_FILES_NAME, priorization);
                                }
                                props.put(priorization, Arrays.copyOfRange(lineParts, 1, lineParts.length));
                            }
                            line = r.readLine();
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (Exception ex) {
                    throw new JuRuntimeException("Couldn't process property file %s", (Throwable)ex, propFile);
                }
                logger.debug(filteredContents.toString());
                if (duplicatePrios.isEmpty()) continue;
                throw new JuRuntimeException(duplicatePrios.toString());
            }
            PropertyChainBuilder chainBuilder = new PropertyChainBuilder();
            XString chainInfo = new XString("Evaluated property chain:");
            chainInfo.increaseIndent();
            object = props.keySet().iterator();
            while (object.hasNext()) {
                int prio = (Integer)object.next();
                chainInfo.addLine(String.valueOf(prio) + ": ");
                String[] lineParts = (String[])props.get(prio);
                String propType = lineParts[0];
                int i = 1;
                while (i < lineParts.length) {
                    XString part = new XString(lineParts[i]);
                    String[] stringArray = part.getPlaceHolders();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String propertyKey = stringArray[n2];
                        String val = chainBuilder.getPropertyChain().get(propertyKey);
                        if (val != null) {
                            part.setPlaceholder(propertyKey, val);
                        } else {
                            logger.debug("Couldn't replace placeholder: " + propertyKey);
                        }
                        ++n2;
                    }
                    lineParts[i] = part.toString();
                    ++i;
                }
                if ("sys".equals(propType)) {
                    chainBuilder.addSystemPropertyEvaluator();
                    chainInfo.addText("System Properties");
                    continue;
                }
                if ("prop".equals(propType)) {
                    AssertUtil.assertTrue("prop property type must be followed by a resource path", lineParts.length > 1);
                    String resourcePath = lineParts[1];
                    boolean optional = lineParts.length > 2 && "optional".equals(lineParts[2]);
                    URL resourceUrl = JuUrl.resource().single().exceptionIfNone(!optional).get(resourcePath);
                    if (resourceUrl != null) {
                        chainBuilder.addResourcePropertyEvaluator(resourceUrl);
                        chainInfo.addText("Properties file: " + resourceUrl);
                        continue;
                    }
                    AssertUtil.assertTrue("Mandatory resource not found: " + resourcePath, optional);
                    chainInfo.addText("Properties file:   >>> optional resource not found: " + resourcePath);
                    continue;
                }
                if ("csv".equals(propType)) {
                    AssertUtil.assertTrue("prop property type must be followed by a resource path and a profile property name", lineParts.length > 2);
                    String resourcePath = lineParts[1];
                    String profilePropertyName = lineParts[2];
                    String profileName = chainBuilder.getPropertyChain().get(profilePropertyName);
                    String defaultColumn = lineParts.length > 3 ? lineParts[2] : "default";
                    URL resourceUrl = JuUrl.singleResource(resourcePath);
                    chainBuilder.addCsvPropertyEvaluator(resourceUrl, profileName, defaultColumn);
                    chainInfo.addFormatted("CSV Properties: %s [profileName=%s, defaultColumn=%s]", resourceUrl, profileName, defaultColumn);
                    continue;
                }
                throw new JuRuntimeException("Unsupported property type: " + propType);
            }
            juPropertyChain = chainBuilder.getPropertyChain();
            logger.info(chainInfo.toString());
        }
        return juPropertyChain;
    }

    public static void clearPropertyChain() {
        juPropertyChain = null;
    }
}

