/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.io.NewLineReader;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtil {
    static final Logger log = LoggerFactory.getLogger(IOUtil.class);
    private static String defaultCharset = null;
    private static int tempFileCounter = 0;
    private final String charset;

    public static synchronized String getDefaultCharset() {
        if (defaultCharset == null) {
            defaultCharset = Charset.defaultCharset().displayName();
        }
        return defaultCharset;
    }

    public static synchronized void setDefaultCharset(String charset) {
        defaultCharset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public IOUtil() {
        this(IOUtil.getDefaultCharset());
    }

    public IOUtil(String charset) {
        this.charset = charset;
    }

    public static void close(Reader reader) {
        try {
            log.debug("Closing Reader: " + ObjectUtils.identityToString((Object)reader));
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ex) {
            log.warn("Could not close Reader instance: " + ex.getMessage());
        }
    }

    public static void close(InputStream stream) {
        try {
            log.debug("Closing InputStream: " + ObjectUtils.identityToString((Object)stream));
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            log.warn("Could not close InputStream instance: " + ex.getMessage());
        }
    }

    public static void close(OutputStream stream) {
        try {
            log.debug("Closing OutputStream: " + ObjectUtils.identityToString((Object)stream));
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            log.warn("Could not close OutputStream instance: " + ex.getMessage());
        }
    }

    public static String toString(Reader reader) {
        try {
            return IOUtils.toString((Reader)reader);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't generate String for Reader", ex);
        }
    }

    public static String toNewLineUnix(String s) {
        NewLineReader reader = new NewLineReader(new StringReader(s), null, "\n");
        return IOUtil.toString(reader);
    }

    public static synchronized Path getTemporaryFile() throws JuException {
        try {
            Path tempPath = Files.createTempFile(String.format("%s_%s_%s", IOUtil.class.getName(), tempFileCounter++, System.currentTimeMillis()), "tmp", new FileAttribute[0]);
            tempPath.toFile().deleteOnExit();
            return tempPath;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't create temporary file", ex);
        }
    }

    public static boolean deleteFile(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new JuRuntimeException("Not a regular file: " + path);
            }
            try {
                Files.delete(path);
                return true;
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't delete file: " + path, ex);
            }
        }
        return false;
    }

    public static boolean deleteFiles(Path ... paths) {
        boolean oneDeleted = false;
        Path[] pathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path path = pathArray[n2];
            if (IOUtil.deleteFile(path)) {
                oneDeleted = true;
            }
            ++n2;
        }
        return oneDeleted;
    }

    public static Path createFile(Path file, boolean overwrite) throws JuException {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new JuException("Directory with file name exists: " + file);
                }
                if (!overwrite) {
                    throw new JuException("File exists: " + file);
                }
                Files.delete(file);
                Files.createFile(file, new FileAttribute[0]);
            } else {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
        }
        catch (JuException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't create file " + file, ex);
        }
        return file;
    }

    public static boolean isSerializable(Object obj) {
        block13: {
            Throwable throwable = null;
            Object var2_4 = null;
            ObjectOutputStream s = new ObjectOutputStream(new ByteArrayOutputStream());
            try {
                s.writeObject(obj);
                if (s == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    if (s != null) {
                        s.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
            }
            s.close();
        }
        return true;
    }

    public static List<Path> listFiles(Path parentDir) {
        return IOUtil.listFiles(parentDir, (Predicate<Path>)Predicates.alwaysTrue());
    }

    public static List<Path> listFiles(Path parentDir, final String ending) {
        return IOUtil.listFiles(parentDir, new Predicate<Path>(){

            public boolean apply(Path input) {
                return input.getFileName().toString().endsWith(ending);
            }
        });
    }

    public static List<Path> listFiles(Path parentDir, final Predicate<Path> predicate) {
        final ArrayList<Path> files = new ArrayList<Path>();
        try {
            Files.walkFileTree(parentDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (predicate.apply((Object)file)) {
                        files.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return files;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't list file of directory %s", (Throwable)ex, parentDir);
        }
    }

    public String loadTextFromUrl(URL url, String ... replacements) throws JuException {
        try {
            if (url == null) {
                throw new JuException("Resource not found: " + url);
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = this.createReader(url);){
                int read;
                StringBuilder sb = new StringBuilder();
                char[] buff = new char[1024];
                while ((read = reader.read(buff)) > 0) {
                    sb.append(buff, 0, read);
                }
                return JuStringUtils.replaceAll(sb.toString(), replacements);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new JuException("Couldn't load text from URL " + url, ex);
        }
    }

    public BufferedReader createReader(URL url) {
        try {
            BufferedReader reader = new BufferedReader(new NewLineReader(new InputStreamReader(url.openStream(), this.charset), null, NewLineReader.LF));
            return reader;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't create reader for URL " + url, ex);
        }
    }

    public Properties loadPropertiesFromUrl(URL url) throws JuException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), this.charset));){
                Properties props = new Properties();
                props.load(reader);
                return props;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new JuException("Couldn't load properties from URL: " + url, ex);
        }
    }

    public void writeTextToFile(String text, Path file, boolean overwrite) throws JuException {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new JuException("Directory with file name exists: " + file);
                }
                if (!overwrite) {
                    throw new JuException("File exists: " + file);
                }
            }
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedWriter w = Files.newBufferedWriter(file, Charset.forName(this.charset), new OpenOption[0]);){
                w.write(text);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JuException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't write text to file: " + file, ex);
        }
    }

    public Writer openWriter(Path file, boolean append, boolean overwrite) throws JuException {
        if (append) {
            AssertUtil.assertFalse("When appending, overwrite must be set to false", overwrite);
        }
        try {
            StandardOpenOption openOption = StandardOpenOption.WRITE;
            if (Files.exists(file, new LinkOption[0]) && append) {
                openOption = StandardOpenOption.APPEND;
            } else {
                IOUtil.createFile(file, overwrite);
            }
            BufferedWriter w = Files.newBufferedWriter(file, Charset.forName(this.charset), openOption);
            return w;
        }
        catch (JuException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't open Writer to: " + file, ex);
        }
    }

    public String toString() {
        return JuStringUtils.toString(this, "charset", this.charset);
    }
}

