/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.MathUtils;
import ch.inftec.ju.util.ReflectUtils;
import ch.inftec.ju.util.XString;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class GuiUtils {
    private GuiUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static XString toXString(TreeModel model) {
        XString xs = new XString();
        Object root = model.getRoot();
        if (root != null) {
            GuiUtils.buildXString(xs, model, model.getRoot());
        }
        return xs;
    }

    private static void buildXString(XString xs, TreeModel model, Object node) {
        xs.addLine(node);
        xs.increaseIndent();
        int i = 0;
        while (i < model.getChildCount(node)) {
            GuiUtils.buildXString(xs, model, model.getChild(node, i));
            ++i;
        }
        xs.decreaseIndent();
    }

    public static void setMinimumSize(Component comp, Dimension minimumSize) {
        Dimension s = comp.getSize();
        if (s.height < minimumSize.height || s.width < minimumSize.width) {
            comp.setSize(MathUtils.max(s, minimumSize));
        }
    }

    public static void showFrame(JFrame frame, boolean exitOnClose) {
        frame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
        frame.pack();
        GuiUtils.setMinimumSize(frame, new Dimension(300, 200));
        frame.setVisible(true);
    }

    public static ImageIcon loadIconResource(URL resourceUrl) {
        ImageIcon icon = new ImageIcon(resourceUrl);
        return icon;
    }

    public static ImageIcon loadIconResource(String resourcePath) throws IllegalArgumentException {
        return GuiUtils.loadIconResource(resourcePath, ReflectUtils.getCallingClass());
    }

    public static ImageIcon loadIconResource(String resourcePath, Class<?> relativeClass) {
        URL url;
        if (relativeClass == null) {
            relativeClass = ReflectUtils.getCallingClass();
        }
        if ((url = JuUrl.resource().relativeTo(ReflectUtils.getCallingClass()).get(resourcePath)) == null) {
            throw new IllegalArgumentException("Icon resource not found: " + resourcePath + " (relative to " + relativeClass + ")");
        }
        return GuiUtils.loadIconResource(url);
    }

    public static void expandAll(JTree tree) {
        Object root = tree.getModel().getRoot();
        if (root != null) {
            GuiUtils.expandAll(tree, new TreePath(root));
        }
    }

    private static void expandAll(JTree tree, TreePath path) {
        Object parent = path.getLastPathComponent();
        int i = 0;
        while (i < tree.getModel().getChildCount(parent)) {
            Object child = tree.getModel().getChild(parent, i);
            TreePath subPath = path.pathByAddingChild(child);
            GuiUtils.expandAll(tree, subPath);
            ++i;
        }
        tree.expandPath(path);
    }
}

