/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import au.com.bytecode.opencsv.CSVReader;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CsvTableLookup {
    private static final char SEPARATOR_CHAR = ';';
    private static final String COMMENT_CHAR = "#";
    private final String defaultColumn;
    private Map<String, Integer> headerIndexes = new HashMap<String, Integer>();
    private List<String> headers;
    private Map<String, String[]> rowValues = new HashMap<String, String[]>();
    private List<String> keys;

    public static CsvTableLookupBuilder build() {
        return new CsvTableLookupBuilder();
    }

    private CsvTableLookup(URL url, String defaultColumn) {
        this.defaultColumn = defaultColumn;
        this.read(url);
    }

    private void read(URL url) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CSVReader reader = new CSVReader((Reader)new IOUtil().createReader(url), ';');){
                List rows = reader.readAll();
                if (rows.size() < 2 || ((String[])rows.get(0)).length < 2) {
                    throw new IllegalArgumentException("File needs at least a header and one row");
                }
                ArrayList<String> headers = new ArrayList<String>();
                int i = 1;
                while (i < ((String[])rows.get(0)).length) {
                    String header = ((String[])rows.get(0))[i];
                    if (this.headerIndexes.containsKey(header)) {
                        throw new IllegalArgumentException("Duplicate header: " + header);
                    }
                    this.headerIndexes.put(header, i);
                    headers.add(header);
                    ++i;
                }
                this.headers = Collections.unmodifiableList(headers);
                ArrayList<String> keys = new ArrayList<String>();
                int i2 = 1;
                while (i2 < rows.size()) {
                    if (((String[])rows.get(i2)).length < 1) {
                        throw new IllegalArgumentException("Unspecified row name at position " + i2);
                    }
                    String key = ((String[])rows.get(i2))[0];
                    AssertUtil.assertNotNull("Key must not be null");
                    if (key != null && !StringUtils.isEmpty((CharSequence)key.trim()) && !key.trim().startsWith(COMMENT_CHAR)) {
                        if (this.rowValues.containsKey(key)) {
                            throw new IllegalArgumentException("Duplicate key: " + key);
                        }
                        this.rowValues.put(key, (String[])rows.get(i2));
                        keys.add(key);
                    }
                    ++i2;
                }
                this.keys = Collections.unmodifiableList(keys);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't read CSV file", ex);
        }
    }

    public String get(String key, String header) {
        String defaultColumnVal;
        String headerVal;
        if (header == null) {
            return null;
        }
        String[] row = this.rowValues.get(key);
        if (row == null) {
            return null;
        }
        Integer index = this.headerIndexes.get(header);
        String string = index != null && index < row.length ? (row[index] == null ? "" : row[index]) : (headerVal = null);
        if (StringUtils.isEmpty(headerVal) && !header.equals(this.defaultColumn) && !StringUtils.isEmpty((CharSequence)(defaultColumnVal = this.get(key, this.defaultColumn)))) {
            return defaultColumnVal;
        }
        return headerVal;
    }

    public Boolean getBoolean(String key, String header) {
        String val = this.get(key, header);
        return val == null ? null : Boolean.valueOf(Boolean.parseBoolean(val));
    }

    public Integer getInteger(String key, String header) {
        String val = this.get(key, header);
        return val == null ? null : Integer.valueOf(Integer.parseInt(val));
    }

    public Long getLong(String key, String header) {
        String val = this.get(key, header);
        return val == null ? null : Long.valueOf(Long.parseLong(val));
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    /* synthetic */ CsvTableLookup(URL uRL, String string, CsvTableLookup csvTableLookup) {
        this(uRL, string);
    }

    public static class CsvTableLookupBuilder {
        private URL url;
        private String defaultColumn;

        private CsvTableLookupBuilder() {
        }

        public CsvTableLookupBuilder from(URL url) {
            this.url = url;
            return this;
        }

        public CsvTableLookupBuilder defaultColumn(String defaultColumn) {
            this.defaultColumn = defaultColumn;
            return this;
        }

        public CsvTableLookup create() {
            AssertUtil.assertNotNull("URL must be specified", this.url);
            return new CsvTableLookup(this.url, this.defaultColumn, null);
        }
    }
}

