/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuCollectionUtils;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthUtil {
    @Autowired
    private AuthenticationProvider authenticationProvider;

    public void authenticate(String username, String password) throws AuthenticationException {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        Authentication auth1 = this.authenticationProvider.authenticate((Authentication)token);
        SecurityContextHolder.getContext().setAuthentication(auth1);
    }

    public boolean isAuthenticated() {
        return SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().isAuthenticated();
    }

    public void logout() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public boolean hasAllRoles(String ... roles) {
        if (this.isAuthenticated()) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            ArrayList<String> rolesList = JuCollectionUtils.asArrayList(roles);
            for (GrantedAuthority grant : auth.getAuthorities()) {
                rolesList.remove(grant.getAuthority());
            }
            return rolesList.size() == 0;
        }
        return false;
    }

    public boolean hasAnyRole(String ... roles) {
        if (this.isAuthenticated()) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            ArrayList<String> rolesList = JuCollectionUtils.asArrayList(roles);
            for (GrantedAuthority grant : auth.getAuthorities()) {
                if (!rolesList.contains(grant.getAuthority())) continue;
                return true;
            }
        }
        return false;
    }
}

