/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.libs;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import junit.framework.Assert;
import org.junit.Test;

public class JavaTest {
    private boolean wasClosed = false;

    @Test
    public void instanceOf() {
        Assert.assertTrue((boolean)(new Integer(1) instanceof Integer));
        Assert.assertTrue((boolean)("Test" instanceof String));
        Assert.assertTrue((boolean)("Test" instanceof Object));
        Assert.assertFalse((boolean)(null instanceof String));
        Assert.assertFalse((boolean)(null instanceof Object));
    }

    @Test
    public void j7try() {
        this.wasClosed = false;
        try (MyClass c = new MyClass();){
            Assert.assertFalse((boolean)this.wasClosed);
        }
        Assert.assertTrue((boolean)this.wasClosed);
        this.wasClosed = false;
        boolean hadException = false;
        try {
            MyClass c = new MyClass();
            Throwable throwable = null;
            try {
                try {
                    Assert.assertFalse((boolean)this.wasClosed);
                    throw new Exception("Fail");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (c != null) {
                    if (throwable != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        c.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception ex) {
            hadException = true;
            Assert.assertTrue((boolean)this.wasClosed);
            Assert.assertTrue((boolean)hadException);
            this.wasClosed = false;
            hadException = false;
            try (MyClass c = new MyClass(true);){
                Assert.fail((String)"Shouldn't reach here");
            }
            catch (Exception ex2) {
                hadException = true;
            }
            Assert.assertFalse((boolean)this.wasClosed);
            Assert.assertTrue((boolean)hadException);
            return;
        }
    }

    @Test
    public void stringFormat() {
        Assert.assertEquals((String)"X-00005", (String)String.format("X-%05d", 5L));
        Assert.assertEquals((String)"X-123456", (String)String.format("X-%05d", 123456L));
    }

    @Test
    public void weakReference() {
        Long[] largeObject = new Long[100000];
        ReferenceQueue queue = new ReferenceQueue();
        WeakReference<Long[]> ref = new WeakReference<Long[]>(largeObject, queue);
        Assert.assertSame((Object)largeObject, ref.get());
        largeObject = null;
        System.gc();
        Assert.assertNull(ref.get());
    }

    private class MyClass
    implements AutoCloseable {
        public MyClass() {
            this(false);
        }

        public MyClass(boolean fail) {
            if (fail) {
                throw new RuntimeException("Failed");
            }
        }

        @Override
        public void close() {
            JavaTest.this.wasClosed = true;
        }
    }
}

