/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.context;

import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.context.GenericContext;
import ch.inftec.ju.util.context.GenericContextUtils;
import ch.inftec.ju.util.context.GenericContextX;
import ch.inftec.ju.util.context.ObjectEvaluator;
import ch.inftec.ju.util.context.ObjectEvaluatorAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class GenericContextTest {
    @Test
    public void getObject() {
        GenericContextX c = this.getContext();
        Assert.assertEquals((Object)new Integer(1), (Object)c.getObject(Integer.class));
        Assert.assertEquals((Object)new Long(2L), (Object)c.getObject(Long.class));
        Assert.assertEquals((String)"Hello", (String)((String)c.getObject(String.class)));
        Assert.assertEquals((Object)"Another String", (Object)c.getObject(Object.class));
        Assert.assertNull((Object)c.getObject(StringBuffer.class));
    }

    @Test
    public void getObjects() {
        GenericContextX c = this.getContext();
        TestUtils.assertCollectionEquals((Collection)JuCollectionUtils.arrayList((Object[])new Integer[]{1}), (Collection)c.getObjects(Integer.class));
        TestUtils.assertCollectionEquals((Collection)JuCollectionUtils.arrayList((Object[])new Long[]{2L, 3L, 4L, 5L}), (Collection)c.getObjects(Long.class));
        TestUtils.assertCollectionEquals((Collection)JuCollectionUtils.arrayList((Object[])new String[]{"Hello", "World"}), (Collection)c.getObjects(String.class));
        TestUtils.assertCollectionEquals((Collection)JuCollectionUtils.arrayList((Object[])new Object[]{"Another String"}), (Collection)c.getObjects(Object.class));
        Assert.assertTrue((boolean)c.getObjects(StringBuffer.class).isEmpty());
    }

    @Test
    public void getObjectByEvaluator() {
        GenericContextX c = this.getContext();
        Assert.assertEquals((Object)new Integer(3), (Object)c.getObject(Integer.class, "val", (Object)3));
        Assert.assertEquals((Object)new Long(44L), (Object)c.getObject(Long.class, "44"));
        Assert.assertEquals((String)"Hello", (String)((String)c.getObject(String.class, (Map)JuCollectionUtils.stringMap((Object[])new Object[]{"val2", "World", "val1", "Hello"}))));
        Assert.assertNull((Object)c.getObject(StringBuffer.class, "bla"));
    }

    @Test
    public void getObjectsByEvaluator() {
        GenericContextX c = this.getContext();
        TestUtils.assertCollectionEquals((Collection)JuCollectionUtils.arrayList((Object[])new Integer[]{3, 6}), (Collection)c.getObjects(Integer.class, "val", (Object)3));
        TestUtils.assertCollectionEquals((Collection)JuCollectionUtils.arrayList((Object[])new Long[]{44L}), (Collection)c.getObjects(Long.class, "44"));
        TestUtils.assertCollectionEquals((Collection)JuCollectionUtils.arrayList((Object[])new String[]{"Hello", "World"}), (Collection)c.getObjects(String.class, (Map)JuCollectionUtils.stringMap((Object[])new Object[]{"val2", "World", "val1", "Hello"})));
        Assert.assertTrue((boolean)c.getObjects(StringBuffer.class, "bla").isEmpty());
    }

    private GenericContextX getContext() {
        GenericContext c = GenericContextUtils.builder().addObjects(Integer.class, (Object[])new Integer[]{1}).addObjects(Long.class, (Object[])new Long[]{2L, 3L, 4L}).addObjects(Long.class, (Object[])new Long[]{5L}).addObjects(String.class, (Object[])new String[]{"Hello", "World"}).addObjects(Object.class, new Object[]{"Another String"}).setObjectEvaluator(Integer.class, (ObjectEvaluator)new ObjectEvaluatorAdapter<Integer>(){

            protected List<Integer> getObjects(String key, Object value) {
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    return JuCollectionUtils.arrayList((Object[])new Integer[]{i, i * 2});
                }
                return null;
            }
        }).setObjectEvaluator(Long.class, (ObjectEvaluator)new ObjectEvaluatorAdapter<Long>(){

            protected List<Long> getObjects(String parameter) {
                return JuCollectionUtils.arrayList((Object[])new Long[]{Long.parseLong(parameter)});
            }
        }).setObjectEvaluator(String.class, (ObjectEvaluator)new ObjectEvaluatorAdapter<String>(){

            protected List<String> doGetObjects(Map<String, Object> map) {
                return JuCollectionUtils.arrayList((Object[])new String[]{map.get("val1").toString(), map.get("val2").toString()});
            }
        }).build();
        return GenericContextUtils.asX((GenericContext)c);
    }
}

