/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.XString;
import org.junit.Assert;
import org.junit.Test;

public class XStringTest {
    @Test
    public void constructor() {
        Assert.assertEquals((Object)new XString().toString(), (Object)"");
        Assert.assertEquals((Object)new XString(null).toString(), (Object)"");
    }

    @Test
    public void indentation() {
        String lineBreak = "\n";
        String indentString = " ";
        String expectedString = "Line1" + lineBreak + indentString + "Line2" + lineBreak + indentString + indentString + indentString + "Line3" + lineBreak + indentString + "Line4" + lineBreak + "Line5";
        XString xs = new XString();
        xs.setLineBreak(lineBreak);
        xs.setIndentString(indentString);
        xs.addLine("Line1");
        xs.increaseIndent();
        xs.addLine("Line2");
        xs.increaseIndent(2);
        xs.addLine("Line3");
        xs.decreaseIndent();
        xs.addLine("Line4");
        xs.decreaseIndent(1);
        xs.addLine("Line5");
        Assert.assertEquals((Object)expectedString, (Object)xs.toString());
        indentString = "  ";
        xs.setIndentString(indentString);
        expectedString = "Line1" + lineBreak + indentString + "Line2" + lineBreak + indentString + indentString + indentString + "Line3" + lineBreak + indentString + "Line4" + lineBreak + "Line5";
        Assert.assertEquals((Object)expectedString, (Object)xs.toString());
        lineBreak = "\r\n";
        xs.setLineBreak(lineBreak);
        expectedString = "Line1" + lineBreak + indentString + "Line2" + lineBreak + indentString + indentString + indentString + "Line3" + lineBreak + indentString + "Line4" + lineBreak + "Line5";
        Assert.assertEquals((Object)expectedString, (Object)xs.toString());
    }

    @Test
    public void addText() {
        XString xs = new XString();
        xs.setLineBreak("#");
        xs.addText("bla");
        xs.assertText(new String[]{"bla"});
        xs.newLine();
        xs.addText("bli");
        Assert.assertEquals((Object)xs.toString(), (Object)"bla#bli");
        XString xsLists = new XString();
        xsLists.setLineBreak("#");
        xsLists.addLine(new Object[]{7, 8, 9});
        xsLists.addLine(new Object[]{1});
        xsLists.addText(new Object[]{2, 3});
        Assert.assertEquals((Object)xsLists.toString(), (Object)"789#123");
        XString xsNull = new XString();
        xsNull.addText(new Object[]{null});
        Assert.assertEquals((Object)xsNull.toString(), (Object)"");
        xsNull.setNullReplacementValue("blabla");
        xsNull.addText(new Object[]{null});
        Assert.assertEquals((Object)xsNull.toString(), (Object)"");
    }

    @Test
    public void comparison() {
        XString xs = new XString("Test");
        Assert.assertEquals((Object)xs, (Object)"Test");
        Assert.assertEquals((Object)xs, (Object)new XString("Test"));
        Assert.assertEquals((Object)new XString(), (Object)"");
        Assert.assertEquals((long)new XString("Test").hashCode(), (long)new XString("Test").hashCode());
        Assert.assertEquals((long)new XString("Test").hashCode(), (long)"Test".hashCode());
    }

    @Test
    public void placeHolders() {
        XString xs = new XString("This is a %test% with % %placeHolders% %but the last isn't");
        Assert.assertArrayEquals((Object[])xs.getPlaceHolders(), (Object[])new String[]{"test", "placeHolders"});
        xs.addLine("Multi line XString... with a %second% placeholder");
        Assert.assertArrayEquals((Object[])xs.getPlaceHolders(), (Object[])new String[]{"test", "placeHolders", "second"});
        XString xsExtreme = new XString("%Place holders %with%extreme%placement%%within%the string%");
        Assert.assertArrayEquals((Object[])xsExtreme.getPlaceHolders(), (Object[])new String[]{"with", "placement", "within"});
        XString xsMultiple = new XString("%Multiple% placeholders %occurring% %Multiple% times %Multiple% %end%");
        Assert.assertArrayEquals((Object[])xsMultiple.getPlaceHolders(), (Object[])new String[]{"Multiple", "occurring", "end"});
        Assert.assertArrayEquals((Object[])new XString("").getPlaceHolders(), (Object[])new String[0]);
        Assert.assertArrayEquals((Object[])new XString(null).getPlaceHolders(), (Object[])new String[0]);
        Assert.assertArrayEquals((Object[])new XString("This String has no placeholders").getPlaceHolders(), (Object[])new String[0]);
        Assert.assertArrayEquals((Object[])new XString("This String has no placeholders %either").getPlaceHolders(), (Object[])new String[0]);
        XString xsDelimiter = new XString("This String has a /different/ delimiter");
        Assert.assertArrayEquals((Object[])xsDelimiter.getPlaceHolders(), (Object[])new String[0]);
        xsDelimiter.setPlaceHolderDelimiter("/");
        Assert.assertArrayEquals((Object[])xsDelimiter.getPlaceHolders(), (Object[])new String[]{"different"});
        XString xsMultiDeli = new XString("This MULTIString has a MULTIdifferentMULTI delimiterMULTI");
        Assert.assertArrayEquals((Object[])xsMultiDeli.getPlaceHolders(), (Object[])new String[0]);
        xsMultiDeli.setPlaceHolderDelimiter("MULTI");
        Assert.assertArrayEquals((Object[])xsMultiDeli.getPlaceHolders(), (Object[])new String[]{"different"});
    }

    @Test
    public void setPlaceHolder() {
        XString xs = new XString("Hello %something% I'm %name% and I'm %age% years old. %name% I said %-(");
        Assert.assertEquals((long)xs.setPlaceholder("name", "Peter"), (long)2L);
        Assert.assertEquals((long)xs.setPlaceholder("age", "22"), (long)1L);
        Assert.assertEquals((long)xs.setPlaceholder("bla", "bli"), (long)0L);
        Assert.assertEquals((Object)xs.toString(), (Object)"Hello %something% I'm Peter and I'm 22 years old. Peter I said %-(");
        XString xsNull = new XString("This is a little %null% test");
        Assert.assertEquals((long)xsNull.setPlaceholder("null", null), (long)1L);
        Assert.assertEquals((Object)xsNull.toString(), (Object)"This is a little  test");
        XString xsNull2 = new XString("This is a little %null% test");
        xsNull2.setNullReplacementValue("{nullReplacement}");
        Assert.assertEquals((long)xsNull2.setPlaceholder("null", null), (long)1L);
        Assert.assertEquals((Object)xsNull2.toString(), (Object)"This is a little {nullReplacement} test");
    }

    @Test
    public void delimitedItems() {
        XString xs = new XString();
        xs.addText("This is a list: ");
        xs.addItems(", ", new Object[]{"one", "two", 3L});
        Assert.assertEquals((Object)xs.toString(), (Object)"This is a list: one, two, 3");
        XString xs2 = new XString("Has line: ");
        xs2.addItems(".", new Object[]{"a", "b"});
        Assert.assertEquals((Object)xs2.toString(), (Object)"Has line: a.b");
        XString xsNull = new XString();
        xsNull.addItems(".", new Object[]{"a", null, "b"});
        Assert.assertEquals((Object)xsNull.toString(), (Object)"a..b");
        XString xsNull2 = new XString();
        xsNull2.setNullReplacementValue("{null}");
        xsNull2.addItems(".", new Object[]{"a", null, "b"});
        Assert.assertEquals((Object)xsNull2.toString(), (Object)"a.{null}.b");
    }

    @Test
    public void lineCount() {
        XString xs = new XString();
        Assert.assertEquals((long)xs.getLineCount(), (long)1L);
        xs.addText("Little Test");
        Assert.assertEquals((long)xs.getLineCount(), (long)1L);
        xs.addLine("Huhu");
        Assert.assertEquals((long)xs.getLineCount(), (long)2L);
        xs.newLine();
        Assert.assertEquals((long)xs.getLineCount(), (long)3L);
    }

    @Test
    public void createEmptyAndClone() throws Exception {
        XString xs = new XString("FirstLine");
        xs.addLine("SecondLine");
        xs.increaseIndent();
        xs.addLine("ThirdLine@p@");
        xs.decreaseIndent();
        xs.addLine("4");
        xs.setIndentString("_");
        xs.setLineBreak("#");
        xs.setPlaceHolderDelimiter("@");
        XString xsEmpty = xs.newEmptyInstance();
        Assert.assertEquals((Object)xsEmpty.getIndentString(), (Object)"_");
        Assert.assertEquals((Object)xsEmpty.getLineBreak(), (Object)"#");
        Assert.assertEquals((Object)xsEmpty.getPlaceHolderDelimiter(), (Object)"@");
        Assert.assertEquals((Object)xsEmpty.toString(), (Object)"");
        XString xsClone = xs.newClonedInstance();
        Assert.assertEquals((Object)xsClone.getIndentString(), (Object)"_");
        Assert.assertEquals((Object)xsClone.getLineBreak(), (Object)"#");
        Assert.assertEquals((Object)xsClone.getPlaceHolderDelimiter(), (Object)"@");
        String expectedString = "FirstLine#SecondLine#_ThirdLine";
        Assert.assertEquals((Object)xsClone.toString(), (Object)(String.valueOf(expectedString) + "@p@#4"));
        XString xsClone2 = xs.newClonedInstance();
        Assert.assertEquals((Object)xsClone.toString(), (Object)xsClone2.toString());
        Assert.assertArrayEquals((Object[])xsClone2.getPlaceHolders(), (Object[])new String[]{"p"});
        xsClone.setPlaceholder("p", "P1");
        xsClone.addText("XX");
        xsClone.addLine("FourthLine");
        Assert.assertEquals((Object)xsClone.toString(), (Object)(String.valueOf(expectedString) + "P1#4XX#FourthLine"));
        xsClone2.addText("");
        Assert.assertEquals((Object)xsClone2.toString(), (Object)(String.valueOf(expectedString) + "@p@#4"));
        xsClone2.setPlaceholder("p", "P2");
        xsClone2.addText("YY");
        xsClone2.addLine("FourthLineToo");
        xsClone.addText("");
        Assert.assertEquals((Object)xsClone.toString(), (Object)(String.valueOf(expectedString) + "P1#4XX#FourthLine"));
        Assert.assertEquals((Object)xsClone2.toString(), (Object)(String.valueOf(expectedString) + "P2#4YY#FourthLineToo"));
    }

    @Test
    public void assertText() {
        String[] vals;
        XString xs = new XString();
        xs.assertText(new String[]{"Huhu"});
        Assert.assertEquals((Object)xs.toString(), (Object)"Huhu");
        xs.assertText(new String[]{"Huhu"});
        Assert.assertEquals((Object)xs.toString(), (Object)"Huhu");
        xs.addText(" bla");
        xs.assertText(new String[]{" "});
        xs.addText("bli");
        Assert.assertEquals((Object)xs.toString(), (Object)"Huhu bla bli");
        XString xs2 = new XString();
        xs2.assertEmptyOrText("Huhu");
        Assert.assertEquals((Object)xs2.toString(), (Object)"");
        xs2.addText("Huhu");
        xs2.assertEmptyOrText("hu");
        xs2.assertEmptyOrText(" ");
        Assert.assertEquals((Object)xs2.toString(), (Object)"Huhu ");
        XString xs3 = new XString("Test (");
        String[] stringArray = vals = new String[]{"A", "B"};
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            xs3.assertText(new String[]{"(", ", "});
            xs3.addText(val);
            ++n2;
        }
        xs3.addText(")");
        Assert.assertEquals((Object)xs3.toString(), (Object)"Test (A, B)");
    }

    @Test
    public void addFormatted() {
        XString xs = new XString();
        xs.addFormatted("Hello %s, I am %d years old.", new Object[]{"World", 100});
        Assert.assertEquals((Object)"Hello World, I am 100 years old.", (Object)xs.toString());
    }

    @Test
    public void parseStringSingle() {
        XString xs = XString.parseLines((String)"one line");
        Assert.assertEquals((long)1L, (long)xs.getLineCount());
    }

    @Test
    public void parseStringMulti() {
        XString xs = XString.parseLines((String)"line1\nline2");
        Assert.assertEquals((long)2L, (long)xs.getLineCount());
        Assert.assertEquals((Object)"line1", (Object)xs.getLine(0));
        Assert.assertEquals((Object)"line2", (Object)xs.getLine(1));
    }

    @Test
    public void parseStringNull() {
        XString xs = XString.parseLines(null);
        Assert.assertEquals((long)1L, (long)xs.getLineCount());
        Assert.assertEquals((Object)"", (Object)xs.getLine(0));
    }

    @Test
    public void parseStringEmpty() {
        XString xs = XString.parseLines((String)"");
        Assert.assertEquals((long)1L, (long)xs.getLineCount());
        Assert.assertEquals((Object)"", (Object)xs.getLine(0));
    }

    @Test
    public void parseStringNewLineLf() {
        XString xs1 = XString.parseLines((String)"a\nb");
        Assert.assertEquals((Object)"\n", (Object)xs1.getLineBreak());
        XString xs2 = XString.parseLines((String)"a");
        Assert.assertEquals((Object)"\n", (Object)xs2.getLineBreak());
    }

    @Test
    public void parseStringNewLineCrLf() {
        XString xs = XString.parseLines((String)"a\r\nb");
        Assert.assertEquals((Object)"\r\n", (Object)xs.getLineBreak());
    }

    @Test
    public void getLongestLineLength() {
        XString xs = new XString();
        Assert.assertEquals((long)0L, (long)xs.getLongestLineLength());
        xs.addLine("abc");
        Assert.assertEquals((long)3L, (long)xs.getLongestLineLength());
        xs.addLine("abcdef");
        Assert.assertEquals((long)6L, (long)xs.getLongestLineLength());
    }

    @Test
    public void isEmpty_returnsTrue_forEmptyStrings() {
        Assert.assertTrue((boolean)new XString().isEmpty());
        Assert.assertTrue((boolean)new XString("").isEmpty());
    }

    @Test
    public void isEmpty_returnsFalse_forNonEmptyStrings() {
        Assert.assertFalse((boolean)new XString(" ").isEmpty());
        Assert.assertFalse((boolean)new XString("a").isEmpty());
        XString xs = new XString("");
        xs.addLine("");
        Assert.assertFalse((boolean)xs.isEmpty());
    }
}

