/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.SystemPropertyTempSetter;
import org.junit.Assert;
import org.junit.Test;

public class SystemPropertyTempSetterTest {
    private static final String PROP = "ju-util.SystemPropertyTempSetterTest";

    @Test
    public void canHandleStrings() {
        System.setProperty(PROP, "v1");
        Throwable throwable = null;
        Object var2_3 = null;
        try (SystemPropertyTempSetter s = new SystemPropertyTempSetter();){
            s.setProperty(PROP, "v1b");
            Assert.assertEquals((Object)"v1b", (Object)System.getProperty(PROP));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)"v1", (Object)System.getProperty(PROP));
    }

    @Test
    public void canHandleNull1() {
        System.clearProperty(PROP);
        Throwable throwable = null;
        Object var2_3 = null;
        try (SystemPropertyTempSetter s = new SystemPropertyTempSetter();){
            s.setProperty(PROP, "v2");
            Assert.assertEquals((Object)"v2", (Object)System.getProperty(PROP));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertNull((Object)System.getProperty(PROP));
    }

    @Test
    public void canHandleNull2() {
        System.setProperty(PROP, "v2");
        Throwable throwable = null;
        Object var2_3 = null;
        try (SystemPropertyTempSetter s = new SystemPropertyTempSetter();){
            s.setProperty(PROP, null);
            Assert.assertNull((Object)System.getProperty(PROP));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)"v2", (Object)System.getProperty(PROP));
    }
}

