/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.ReflectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ReflectUtils_GetAnnotationsTest {
    @Test
    public void canGetAnnotation_forClass() {
        List annos = ReflectUtils.getAnnotations(BaseClass.class, Anno.class, (boolean)false);
        this.assertAnnotations(annos, "BaseClass");
    }

    @Test
    public void canGetAnnotation_forExtendingClass_withoutSuperClassAnnotation() {
        List annos = ReflectUtils.getAnnotations(ExtendingClass1.class, Anno.class, (boolean)false);
        this.assertAnnotations(annos, "ExtendingClass");
    }

    @Test
    public void canGetAnnotation_forExtendingClass_withSuperClassAnnotation() {
        List annos = ReflectUtils.getAnnotations(ExtendingClass1.class, Anno.class, (boolean)true);
        this.assertAnnotations(annos, "ExtendingClass", "BaseClass");
    }

    @Test
    public void extendingClassWithoutAnnotation_returnsNull_withoutBaseClass() {
        List annos = ReflectUtils.getAnnotations(ExtendingClass2.class, Anno.class, (boolean)false);
        this.assertAnnotations(annos, new String[0]);
    }

    @Test
    public void extendingClassWithoutAnnotation_returnsBaseAnnotation_withBaseClass() {
        List annos = ReflectUtils.getAnnotations(ExtendingClass2.class, Anno.class, (boolean)true);
        this.assertAnnotations(annos, "BaseClass");
    }

    @Test
    public void canGetAnnotation_forMethod() throws Exception {
        List annos = ReflectUtils.getAnnotations((Method)BaseClass.class.getMethod("m1", null), Anno.class, (boolean)false, (boolean)false, (boolean)false);
        this.assertAnnotations(annos, "BaseClass.m1");
    }

    @Test
    public void canGetAnnotation_forMethod_withoutOverriddenMethod() throws Exception {
        List annos = ReflectUtils.getAnnotations((Method)ExtendingClass1.class.getMethod("m1", null), Anno.class, (boolean)false, (boolean)false, (boolean)false);
        this.assertAnnotations(annos, "ExtendingClass1.m1");
    }

    @Test
    public void canGetAnnotation_forMethod_withOverriddenMethod() throws Exception {
        List annos = ReflectUtils.getAnnotations((Method)ExtendingClass1.class.getMethod("m1", null), Anno.class, (boolean)true, (boolean)false, (boolean)false);
        this.assertAnnotations(annos, "ExtendingClass1.m1", "BaseClass.m1");
    }

    @Test
    public void canGetAnnotation_forMethod_withOverriddenMethod_thatIsNotOverriding() throws Exception {
        List annos = ReflectUtils.getAnnotations((Method)ExtendingClass2.class.getMethod("m2", null), Anno.class, (boolean)true, (boolean)false, (boolean)true);
        this.assertAnnotations(annos, "ExtendingClass2.m2");
    }

    @Test
    public void canGetAnnotation_forMethod_includingOverriddenMethods_andClass() throws Exception {
        List annos = ReflectUtils.getAnnotations((Method)ExtendingClass1.class.getMethod("m1", null), Anno.class, (boolean)true, (boolean)true, (boolean)false);
        this.assertAnnotations(annos, "ExtendingClass1.m1", "BaseClass.m1", "ExtendingClass");
    }

    @Test
    public void canGetAnnotation_forMethod_includingOverriddenMethods_andClasses() throws Exception {
        List annos = ReflectUtils.getAnnotations((Method)ExtendingClass1.class.getMethod("m1", null), Anno.class, (boolean)true, (boolean)true, (boolean)true);
        this.assertAnnotations(annos, "ExtendingClass1.m1", "BaseClass.m1", "ExtendingClass", "BaseClass");
    }

    private void assertAnnotations(List<Anno> annotations, String ... values) {
        Assert.assertEquals((long)values.length, (long)annotations.size());
        int i = 0;
        while (i < values.length) {
            Assert.assertEquals((Object)values[i], (Object)annotations.get(i).value());
            ++i;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Anno {
        public String value();
    }

    @Anno(value="BaseClass")
    public static class BaseClass {
        @Anno(value="BaseClass.m1")
        public void m1() {
        }
    }

    @Anno(value="ExtendingClass")
    public static class ExtendingClass1
    extends BaseClass {
        @Override
        @Anno(value="ExtendingClass1.m1")
        public void m1() {
        }
    }

    public static class ExtendingClass2
    extends BaseClass {
        @Override
        public void m1() {
        }

        @Anno(value="ExtendingClass2.m2")
        public void m2() {
        }
    }
}

