/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.ReflectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ReflectTest {
    @Test
    public void getInnerClass_returnesClass_ifExists() {
        Class innerClass = ReflectUtils.getInnerClass(ReflectTest.class, (String)"InnerClass");
        Assert.assertEquals(InnerClass.class, (Object)innerClass);
    }

    @Test
    public void getInnerClass_returnesNull_ifNotExists() {
        Class innerClass = ReflectUtils.getInnerClass(ReflectTest.class, (String)"UnknownInnerClass");
        Assert.assertNull((Object)innerClass);
    }

    @Test
    public void getCallingClass() {
        new CalledClass().callMe();
    }

    @Test
    public void getMethod_returnsMethod_forValidMethod() {
        Assert.assertEquals((Object)"getMethod_returnsMethod_forValidMethod", (Object)ReflectUtils.getMethod(this.getClass(), (String)"getMethod_returnsMethod_forValidMethod", null).getName());
    }

    @Test
    public void getMethod_returnsNull_forInvalidMethod() {
        Assert.assertNull((Object)ReflectUtils.getMethod(this.getClass(), (String)"bla", null));
    }

    @Test
    public void getDeclaredMethod() throws Exception {
        Method m1 = ReflectUtils.getDeclaredMethod(ReflectTest.class, (String)"getMethodTest", (Class[])new Class[]{Long.class, Long.class});
        int res1 = (Integer)m1.invoke((Object)new ReflectTest(), new Object[]{null, null});
        Assert.assertEquals((long)res1, (long)2L);
        Method m2 = ReflectUtils.getDeclaredMethod(ReflectTest.class, (String)"getMethodTest", (Class[])new Class[]{String.class, Long.class});
        int res2 = (Integer)m2.invoke((Object)new ReflectTest(), new Object[]{null, null});
        Assert.assertEquals((long)res2, (long)1L);
    }

    @Test
    public void getStaticFieldValue() {
        Assert.assertEquals((Object)"testValue", (Object)ReflectUtils.getStaticFieldValue(StaticFieldClass1.class, (String)"test", null));
        Assert.assertEquals((Object)"test2Value", (Object)ReflectUtils.getStaticFieldValue(StaticFieldClass2.class, (String)"test2", null));
        Assert.assertEquals((Object)"def", (Object)ReflectUtils.getStaticFieldValue(StaticFieldClass2.class, null, (Object)"def"));
        Assert.assertNull((Object)ReflectUtils.getStaticFieldValue(StaticFieldClass2.class, (String)"test", null));
        Assert.assertEquals((Object)"def", (Object)ReflectUtils.getStaticFieldValue(StaticFieldClass2.class, (String)"test3", (Object)"def"));
        try {
            ReflectUtils.getStaticFieldValue(StaticFieldClass1.class, (String)"notAccessible", null);
            Assert.fail((String)"Expected access to fail");
        }
        catch (JuRuntimeException ex) {
            Assert.assertEquals(IllegalAccessException.class, ex.getCause().getClass());
        }
    }

    @Test
    public void newInstance() {
        Assert.assertEquals(StaticFieldClass1.class, ((StaticFieldClass1)ReflectUtils.newInstance(StaticFieldClass1.class, (boolean)true, (Object[])new Object[0])).getClass());
        Assert.assertEquals(StaticFieldClass2.class, ((StaticFieldClass2)ReflectUtils.newInstance(StaticFieldClass2.class, (boolean)false, (Object[])new Object[0])).getClass());
        try {
            ReflectUtils.newInstance(StaticFieldClass1.class, (boolean)false, (Object[])new Object[0]);
            Assert.fail((String)"Shouldn't be able to invoke private constructor");
        }
        catch (JuRuntimeException ex) {
            Assert.assertEquals(IllegalAccessException.class, ex.getCause().getClass());
        }
    }

    @Test
    public void newInstance_withParameters() {
        ParamConstructor pc = (ParamConstructor)ReflectUtils.newInstance(ParamConstructor.class, (boolean)false, (Object[])new Object[]{"Param"});
        Assert.assertEquals((Object)"Param", (Object)pc.getName());
    }

    @Test
    public void getDeclaredFieldsByAnnotation() {
        List f1 = ReflectUtils.getDeclaredFieldsByAnnotation(AnnoClass.class, Anno1.class);
        Assert.assertEquals((long)0L, (long)f1.size());
        List f2 = ReflectUtils.getDeclaredFieldsByAnnotation(AnnoClass.class, Anno2.class);
        Assert.assertEquals((long)2L, (long)f2.size());
        Assert.assertEquals((Object)"privateField1", (Object)((Field)f2.get(0)).getName());
        Assert.assertEquals((Object)"privateField2", (Object)((Field)f2.get(1)).getName());
    }

    @Test
    public void getDeclaredFieldValueByAnnotation() {
        AnnoClass a1 = new AnnoClass();
        Assert.assertNull((Object)ReflectUtils.getDeclaredFieldValueByAnnotation((Object)a1, Anno1.class, (boolean)true));
        Assert.assertEquals((Object)11, (Object)ReflectUtils.getDeclaredFieldValueByAnnotation((Object)a1, Anno2.class, (boolean)true));
    }

    protected int getMethodTest(Object o1, Object o2) {
        return 1;
    }

    protected int getMethodTest(Long o1, Long o2) {
        return 2;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Anno1 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Anno2 {
    }

    private static class AnnoBaseClass {
        @Anno1
        protected int inheritedField = 1;

        private AnnoBaseClass() {
        }
    }

    private static class AnnoClass
    extends AnnoBaseClass {
        @Anno2
        private int privateField2 = 22;
        @Anno2
        private int privateField1 = 11;

        private AnnoClass() {
        }
    }

    private class CalledClass {
        private CalledClass() {
        }

        public void callMe() {
            Assert.assertEquals((Object)ReflectUtils.getCallingClass(), ReflectTest.class);
        }
    }

    public static class InnerClass {
    }

    public static class ParamConstructor {
        private final String name;

        public ParamConstructor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class StaticFieldClass1 {
        private static String test = "testValue";
        public static String notAccessible;

        private StaticFieldClass1() {
        }
    }

    public static class StaticFieldClass2 {
        public static String test2 = "test2Value";
        public static String test3 = null;
    }
}

