/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.PropertyChainBuilder;
import org.junit.Assert;
import org.junit.Test;

public class PropertyChainTest {
    @Test
    public void builder_buildsSystemPropertyEvaluator() {
        PropertyChain chain = new PropertyChainBuilder().addSystemPropertyEvaluator().getPropertyChain();
        String key = "ch.inftec.ju.util.PropertyChainTest.prop1";
        System.setProperty(key, "val1");
        Assert.assertEquals((Object)"val1", (Object)chain.get(key));
    }

    @Test
    public void builder_buildsResourcePropertyEvaluator() {
        PropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest.properties", false).getPropertyChain();
        Assert.assertEquals((Object)"val1", (Object)chain.get("prop1"));
    }

    @Test
    public void resourcePropertyEvaluator_ignoresMissingResource() {
        PropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("xyz", true).addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest.properties", true).getPropertyChain();
        Assert.assertEquals((Object)"val1", (Object)chain.get("prop1"));
    }

    @Test
    public void propertyChain_chainsEvaluators() {
        PropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest-2.properties", false).addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest.properties", false).addSystemPropertyEvaluator().getPropertyChain();
        String key = "ch.inftec.ju.util.PropertyChainTest.prop1";
        System.setProperty(key, "val1");
        Assert.assertEquals((Object)"val1b", (Object)chain.get("prop1"));
        Assert.assertEquals((Object)"val1", (Object)chain.get(key));
    }

    @Test
    public void propertyChain_convertsInteger() {
        PropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest_conversion.properties", false).getPropertyChain();
        Assert.assertEquals((Object)new Integer(1), (Object)chain.get("intProp1", Integer.class));
        Assert.assertEquals((Object)new Integer(-1), (Object)chain.get("intProp2", Integer.class));
    }

    @Test
    public void propertyChain_convertsBoolean() {
        PropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest_conversion.properties", false).getPropertyChain();
        Assert.assertTrue((boolean)((Boolean)chain.get("booleanProp1", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)chain.get("booleanProp2", Boolean.class)));
    }
}

