/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.CsvTableLookup;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.JuUrl;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Assert;
import org.junit.Test;

public class CsvTableLookupTest {
    @Test
    public void csvTableLookup_canReadCsvFile() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertEquals((String)"V11", (String)l.get("R1", "H1"));
    }

    @Test
    public void csvTableLookup_forEmptyCell_returnsEmpty() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertEquals((String)"", (String)l.get("R1", "H3"));
        Assert.assertEquals((String)"", (String)l.get("R1", "H4"));
    }

    @Test
    public void csvTableLookup_forInvalidCell_returnsNull() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertNull((Object)l.get("R1", "H5"));
    }

    @Test
    public void get_ifDefaultColumnSet_returnsDefaultColumnValue() {
        CsvTableLookup l = this.tableLookupBuilder().defaultColumn("H1").create();
        Assert.assertEquals((String)"V11", (String)l.get("R1", "H4"));
    }

    @Test
    public void get_ifDefaultColumnSetAndInvalidColumn_returnsDefaultValue() {
        CsvTableLookup l = this.tableLookupBuilder().defaultColumn("H1").create();
        Assert.assertEquals((String)"V11", (String)l.get("R1", "H4"));
    }

    @Test
    public void csvTableLookup_returnsAllHeaders() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(Arrays.asList("H1", "H2", "H3", "H4"), (Collection)l.getHeaders()));
    }

    @Test
    public void csvTableLookup_returnsAllKeys() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(Arrays.asList("R1", "R2", "R3", "R4"), (Collection)l.getKeys()));
    }

    @Test
    public void csvTableLookup_returnsBoolean() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)l.getBoolean("R4", "H1"));
    }

    @Test
    public void csvTableLookup_returnsInteger() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertEquals((Object)new Integer(7), (Object)l.getInteger("R4", "H2"));
    }

    @Test
    public void csvTableLookup_returnsLong() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertEquals((Object)new Long(7L), (Object)l.getLong("R4", "H2"));
    }

    @Test
    public void csvTableLookup_forNullKey_returnsNull() {
        CsvTableLookup l = this.tableLookupBuilder().create();
        Assert.assertNull((Object)l.get(null, "H1"));
    }

    private CsvTableLookup.CsvTableLookupBuilder tableLookupBuilder() {
        return CsvTableLookup.build().from(JuUrl.resource().relativeTo(CsvTableLookupTest.class).get("data.csv"));
    }
}

