/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.WeakReferenceIterable;
import ch.inftec.ju.util.comparison.EqualityTester;
import ch.inftec.ju.util.comparison.ValueComparator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections15.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class CollectionTest {
    @Test
    public void mapEquals() {
        HashMap<String, Integer> map1 = new HashMap<String, Integer>();
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map1.put("one", 1);
        map2.put("two", 2);
        Assert.assertFalse((boolean)JuCollectionUtils.mapEquals(map1, map2));
        map1.put("two", 2);
        map2.put("one", 1);
        Assert.assertTrue((boolean)JuCollectionUtils.mapEquals(map1, map2));
        Assert.assertFalse((boolean)JuCollectionUtils.mapEquals(null, map2));
        Assert.assertFalse((boolean)JuCollectionUtils.mapEquals(map1, null));
        Assert.assertTrue((boolean)JuCollectionUtils.mapEquals(null, null));
    }

    @Test
    public void mapEqualsEqualityTester() {
        HashMap<String, Integer> map1 = new HashMap<String, Integer>();
        HashMap<String, Long> map2 = new HashMap<String, Long>();
        map1.put("one", 1);
        map2.put("one", 1L);
        Assert.assertFalse((boolean)JuCollectionUtils.mapEquals(map1, map2));
        Assert.assertTrue((boolean)JuCollectionUtils.mapEquals(map1, map2, (EqualityTester)ValueComparator.INSTANCE));
    }

    @Test
    public void collectionEquals() {
        ArrayList<String> c1 = new ArrayList<String>();
        ArrayList<String> c2 = new ArrayList<String>();
        c1.add("one");
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(c1, c2));
        c1.add("two");
        c2.add("one");
        c2.add("two");
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(c1, c2));
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(null, c2));
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(c1, null));
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(null, null));
    }

    @Test
    public void collectionEquals_forOtherOrder_returnsFalse() {
        ArrayList<String> c1 = new ArrayList<String>();
        ArrayList<String> c2 = new ArrayList<String>();
        c1.add("one");
        c1.add("two");
        c2.add("two");
        c2.add("one");
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(c1, c2));
    }

    @Test
    public void collectionEqualsIgnoreOrder_forDifferentlyOrderedCollections_returnsTrue() {
        ArrayList<String> c1 = new ArrayList<String>();
        ArrayList<String> c2 = new ArrayList<String>();
        c1.add("one");
        c1.add("two");
        c2.add("two");
        c2.add("one");
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEqualsIgnoreOrder(c1, c2));
    }

    @Test
    public void collectionEqualsIgnoreOrder_forDifferencCollections_returnsFalse() {
        ArrayList<String> c1 = new ArrayList<String>();
        ArrayList<String> c2 = new ArrayList<String>();
        c1.add("one");
        c1.add("two");
        c2.add("two");
        c2.add("three");
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEqualsIgnoreOrder(c1, c2));
    }

    @Test
    public void stringMap() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("one", 1);
        m.put("two", 2);
        m.put("null", null);
        TestUtils.assertMapEquals(m, (Map)JuCollectionUtils.stringMap((Object[])new Object[]{"one", 1, "two", 2, "null", null}));
    }

    @Test
    public void arrayListAndUnmodifiableList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Hello");
        list.add("World");
        list.add(null);
        TestUtils.assertCollectionEquals(list, (Collection)JuCollectionUtils.arrayList((Object[])new String[]{"Hello", "World", null}));
        List unmodifiableList = JuCollectionUtils.unmodifiableList((Object[])new String[]{"Hello", "World", null});
        TestUtils.assertCollectionEquals(list, (Collection)unmodifiableList);
        try {
            unmodifiableList.add("bla");
            Assert.fail((String)"Could add element to unmodifiable list");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void isSubsetOf() {
        Object[] array = new String[]{"A", "B", "C"};
        Assert.assertTrue((boolean)JuCollectionUtils.isSubsetOf((Object[])new String[0], (Object[])array));
        Assert.assertTrue((boolean)JuCollectionUtils.isSubsetOf((Object[])new String[]{"A", "B"}, (Object[])array));
        Assert.assertFalse((boolean)JuCollectionUtils.isSubsetOf((Object[])new String[]{"X"}, (Object[])array));
        Assert.assertFalse((boolean)JuCollectionUtils.isSubsetOf(null, (Object[])array));
        Assert.assertTrue((boolean)JuCollectionUtils.isSubsetOf(null, null));
        Assert.assertFalse((boolean)JuCollectionUtils.isSubsetOf((Object[])new String[0], null));
        Assert.assertFalse((boolean)JuCollectionUtils.isSubsetOf((Object[])new String[]{"A"}, null));
    }

    @Test
    public void arrayEquals() {
        Assert.assertTrue((boolean)JuCollectionUtils.arrayEquals(null, null));
        Assert.assertTrue((boolean)JuCollectionUtils.arrayEquals((Object[])new Long[0], (Object[])new Long[0]));
        Assert.assertTrue((boolean)JuCollectionUtils.arrayEquals((Object[])new Long[0], (Object[])new Float[0]));
        Assert.assertTrue((boolean)JuCollectionUtils.arrayEquals((Object[])new Long[3], (Object[])new Float[3]));
        Assert.assertFalse((boolean)JuCollectionUtils.arrayEquals((Object[])new Long[0], null));
        Assert.assertTrue((boolean)JuCollectionUtils.arrayEquals((Object[])new Long[]{1L, 2L, 3L}, (Object[])new Long[]{1L, 2L, 3L}));
        Assert.assertFalse((boolean)JuCollectionUtils.arrayEquals((Object[])new Long[]{1L, 2L, 3L}, (Object[])new Long[]{1L, 2L, 4L}));
    }

    public void selectStartingWith() {
        List<String> col = Arrays.asList("a1", "A2", "b1", null);
        Collection c1 = JuCollectionUtils.selectStartingWith(col, (String)"a", (boolean)true);
        TestUtils.assertCollectionEquals((Collection)c1, (Object[])new String[]{"a1"});
        Collection c2 = JuCollectionUtils.selectStartingWith(col, (String)"a", (boolean)false);
        TestUtils.assertCollectionEquals((Collection)c2, (Object[])new String[]{"a1", "A2"});
        Collection c3 = JuCollectionUtils.selectStartingWith(col, (String)"", (boolean)false);
        TestUtils.assertCollectionEquals((Collection)c3, (Object[])new String[]{"a1", "A2", "b1"});
        Collection c4 = JuCollectionUtils.selectStartingWith(col, (String)"", (boolean)false);
        TestUtils.assertCollectionEquals((Collection)c4, (Object[])new String[]{null});
    }

    @Test
    public void collectionContains() {
        List<String> col = Arrays.asList("a1", "A2", "b1", null);
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContains(col, (Object[])new String[]{"a1"}));
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContains(col, (Object[])new String[]{"a1", "b1"}));
        Assert.assertFalse((boolean)JuCollectionUtils.collectionContains(col, (Object[])new String[]{"a1", "A3"}));
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContains(col, (Object[])new String[0]));
    }

    public void collectionContainsIgnoreCase() {
        List<String> col = Arrays.asList("a1", "A2", "b1", null);
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContainsIgnoreCase(col, (String[])new String[]{"a1"}));
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContainsIgnoreCase(col, (String[])new String[]{"A1"}));
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContainsIgnoreCase(col, (String[])new String[]{"A1", "b1"}));
        Assert.assertFalse((boolean)JuCollectionUtils.collectionContainsIgnoreCase(col, (String[])new String[]{"a1", "A3"}));
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContainsIgnoreCase(col, (String[])new String[0]));
    }

    @Test
    public void weakReferenceIterable() {
        WeakReferenceIterable it = JuCollectionUtils.newWeakReferenceIterable();
        it.add((Object)new LargeObject(false));
        Assert.assertEquals((long)1L, (long)IteratorUtils.toList((Iterator)it.iterator()).size());
        LargeObject weakObject = new LargeObject(true);
        it.addWeak((Object)weakObject);
        WeakReference<LargeObject> weakObjectRef = new WeakReference<LargeObject>(weakObject);
        Assert.assertEquals((long)2L, (long)IteratorUtils.toList((Iterator)it.iterator()).size());
        Assert.assertFalse((boolean)((LargeObject)IteratorUtils.toList((Iterator)it.iterator()).get((int)0)).isWeak);
        Assert.assertSame((Object)weakObject, IteratorUtils.toList((Iterator)it.iterator()).get(1));
        weakObject = null;
        int i = 0;
        while (i < 100) {
            new LargeObject(true);
            ++i;
        }
        System.gc();
        Assert.assertNull(weakObjectRef.get());
        Assert.assertEquals((long)1L, (long)IteratorUtils.toList((Iterator)it.iterator()).size());
    }

    @Test
    public void weakReferenceIterableIterator() {
        WeakReferenceIterable it = JuCollectionUtils.newWeakReferenceIterable();
        Iterator i1 = it.iterator();
        Assert.assertFalse((boolean)i1.hasNext());
        Iterator i2 = it.iterator();
        try {
            i2.next();
            Assert.fail((String)"Next should throw exception on empty list");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            i2.remove();
            Assert.fail((String)"Next should throw exception on empty list");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)i1.hasNext());
        LargeObject l1 = new LargeObject(false);
        it.add((Object)l1);
        Iterator i3 = it.iterator();
        Assert.assertTrue((boolean)i3.hasNext());
        Assert.assertTrue((boolean)i3.hasNext());
        Assert.assertSame((Object)l1, i3.next());
        Assert.assertFalse((boolean)i3.hasNext());
        Iterator i4 = it.iterator();
        Assert.assertSame((Object)l1, i4.next());
        Assert.assertFalse((boolean)i4.hasNext());
        it.clear();
        Assert.assertFalse((boolean)it.iterator().hasNext());
        LargeObject l2 = new LargeObject(true);
        it.add((Object)l1);
        it.addWeak((Object)l2);
        Iterator i5 = it.iterator();
        Assert.assertSame((Object)l1, i5.next());
        Assert.assertTrue((boolean)i5.hasNext());
        i5.remove();
        Assert.assertTrue((boolean)i5.hasNext());
        Assert.assertSame((Object)l2, i5.next());
        Assert.assertFalse((boolean)i5.hasNext());
        i5.remove();
        Assert.assertFalse((boolean)it.iterator().hasNext());
        it.clear();
        LargeObject l3 = new LargeObject(true);
        it.add((Object)l1);
        it.addWeak((Object)l2);
        it.addWeak((Object)l3);
        Iterator i6 = it.iterator();
        Assert.assertSame((Object)l1, i6.next());
        Assert.assertTrue((boolean)i6.hasNext());
        l2 = null;
        l3 = null;
        System.gc();
        Assert.assertTrue((boolean)i6.hasNext());
        Assert.assertNotNull(i6.next());
        Assert.assertFalse((boolean)i6.hasNext());
        Iterator i7 = it.iterator();
        i7.next();
        it.add((Object)new LargeObject(false));
        try {
            i7.hasNext();
            Assert.fail((String)"hasNext should throw exception when Iterable was modified in the meantime");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Test
    public void weakReferenceIterableQueue() {
        Object o;
        WeakReferenceIterable it = JuCollectionUtils.newWeakReferenceIterable();
        ArrayList<Object> objects = new ArrayList<Object>();
        int i = 0;
        while (i < 10000) {
            o = new Object();
            objects.add(o);
            it.addWeak(o);
            ++i;
        }
        objects.clear();
        i = 0;
        while (i < 1000) {
            o = new Object();
            objects.add(o);
            it.add(o);
            ++i;
        }
        System.gc();
        it.addWeak(new Object());
    }

    @Test
    public void collectionUtils_asSameOrderSet() {
        ArrayList list = JuCollectionUtils.asArrayList((Object[])new String[]{"z", "a", "b", "z", "b"});
        Set set = JuCollectionUtils.asSameOrderSet((Collection)list);
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)JuCollectionUtils.arrayEquals((Object[])new String[]{"z", "a", "b"}, (Object[])set.toArray()));
    }

    @Test
    public void collectionUtils_asSortedSet() {
        ArrayList list = JuCollectionUtils.asArrayList((Object[])new String[]{"z", "a", "b", "z", "b"});
        Set set = JuCollectionUtils.asSortedSet((Collection)list);
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)JuCollectionUtils.arrayEquals((Object[])new String[]{"a", "b", "z"}, (Object[])set.toArray()));
    }

    @Test
    public void collectionUtils_canCreatedTypedArrayList() {
        ArrayList list = JuCollectionUtils.asTypedArrayList(Object.class, (Object[])new String[]{"a", "b"});
        Assert.assertEquals((Object)"a", list.get(0));
        Assert.assertEquals((Object)"b", list.get(1));
    }

    private static class LargeObject {
        Byte[] b = new Byte[1000];
        final boolean isWeak;

        public LargeObject(boolean isWeak) {
            this.isWeak = isWeak;
        }
    }
}

