package ch.inftec.ju.util;

import java.nio.file.Files;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JuUrlTest {
	@Rule
	public ExpectedException thrown = ExpectedException.none();
	
	@Test
	public void nonExistingResource_returnsNull() {
		Assert.assertNull(JuUrl.resource("blibla"));
	}
	
	@Test
	public void nonExistingResource_returnsNull_withBuilder() {
		Assert.assertNull(JuUrl.resource().get("blibla"));
	}
	
	@Test
	public void resource_usingClassLookup() {
		Assert.assertNotNull(JuUrl.resource().relativeTo(JuUrlTest.class).get("testResource.txt"));
	}
	
	@Test
	public void resource_usingClassLoader() {
		Assert.assertNotNull(JuUrl.resource().get("ch/inftec/ju/util/testResource.txt"));
	}
	
	@Test
	public void multipleResources() {
		Assert.assertEquals(2, JuUrl.resource().getAll("ju.properties.files").size());
	}
	
	@Test
	public void exception_ifSingle_withMultipleResources() {
		thrown.expect(JuRuntimeException.class);
		thrown.expectMessage("Found more than");
		thrown.expectMessage("ju.properties.files");
		
		JuUrl.resource().single().get("ju.properties.files");
	}
	
	@Test
	public void exception_ifExceptionIfNone_andNoResource() {
		thrown.expect(JuRuntimeException.class);
		thrown.expectMessage("Resource not found");
		thrown.expectMessage("blibla");
		
		JuUrl.resource().exceptionIfNone().get("blibla");
	}
	
	@Test
	public void existingFile() {
		Assert.assertTrue(Files.exists(JuUrl.existingFile("src/main/resources/ju.properties.files")));
	}
	
	@Test
	public void existingFile_usingRelativeTo() {
		Assert.assertTrue(Files.exists(JuUrl.path().relativeTo("src/main/resources").get("ju.properties.files")));
	}
	
	@Test
	public void existingFileMethod_throwsException_ifFileNotExisting() {
		thrown.expect(JuRuntimeException.class);
		thrown.expectMessage("Path doesn't exist");
		thrown.expectMessage("blibla");
		
		JuUrl.existingFile("blibla");
	}
	
	@Test
	public void path_throwsException_ifPathIsNoFile() {
		thrown.expect(JuRuntimeException.class);
		thrown.expectMessage("Path is not a file");
		thrown.expectMessage("src");
		
		JuUrl.path().file().get("src/main");
	}
}