/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.persistable;

import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.persistable.GenericMemento;
import ch.inftec.ju.util.persistable.GenericMementoUtils;
import ch.inftec.ju.util.persistable.GenericMementoX;
import ch.inftec.ju.util.persistable.MementoStorage;
import ch.inftec.ju.util.persistable.MemoryMementoStorage;
import ch.inftec.ju.util.persistable.Persistable;
import ch.inftec.ju.util.persistable.PersistableManager;
import ch.inftec.ju.util.persistable.StringMementoStorage;
import ch.inftec.ju.util.persistable.TypeHandler;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.collections15.map.ListOrderedMap;
import org.junit.Assert;
import org.junit.Test;

public class PersistenceManagerTest {
    @Test
    public void stringStorage() {
        StringMementoStorage storage = new StringMementoStorage();
        PersistableManager manager = GenericMementoUtils.newPersistableManager((MementoStorage)storage, (TypeHandler)GenericMementoUtils.DEFAULT_TYPE_HANDLER);
        manager.persist((Persistable)this.getTestProperties());
        TestUtils.assertEqualsResource((String)"stringStorage.txt", (String)storage.toString(), (String[])new String[0]);
    }

    @Test
    public void defaultTypeHandler() {
        TypeHandler h = GenericMementoUtils.DEFAULT_TYPE_HANDLER;
        String className = PersistableProperties.class.getName();
        Assert.assertEquals((Object)"ch.inftec.ju.util.persistable.PersistenceManagerTest$PersistableProperties", (Object)className);
        Assert.assertEquals((Object)className, (Object)h.getTypeName((Persistable)new PersistableProperties()));
        Assert.assertEquals(PersistableProperties.class, h.newInstance(className).getClass());
    }

    @Test
    public void memoryStorage() {
        MemoryMementoStorage storage = new MemoryMementoStorage();
        PersistableManager manager = GenericMementoUtils.newPersistableManager((MementoStorage)storage, (TypeHandler)GenericMementoUtils.DEFAULT_TYPE_HANDLER);
        Long id = manager.persist((Persistable)this.getTestProperties());
        GenericMemento o1 = storage.loadMemento(id).getMemento();
        Assert.assertEquals((long)1L, (long)o1.getChildren().size());
        Assert.assertEquals((long)3L, (long)o1.getAttributes().size());
        Assert.assertEquals((Object)"p1", (Object)((GenericMemento.MementoAttribute)o1.getAttributes().get(0)).getKey());
        Assert.assertEquals((Object)"v1", (Object)((GenericMemento.MementoAttribute)o1.getAttributes().get(0)).getStringValue());
        GenericMemento o2 = storage.loadMemento(Long.valueOf(1L)).getMemento();
        Assert.assertEquals((Object)"v23", (Object)((GenericMemento.MementoAttribute)o2.getAttributes().get(2)).getStringValue());
        Assert.assertNull((Object)storage.loadMemento(Long.valueOf(99L)));
        Date dateNow = new Date();
        GenericMemento m = GenericMementoUtils.builder().add("k1", (Object)"string").add("k2", (Object)dateNow).add("k3", (Object)99L).add("k4", "hello", dateNow, Long.valueOf(100L)).build();
        Long mId = storage.persistMemento(m, "M");
        GenericMemento ml = storage.loadMemento(mId).getMemento();
        GenericMementoX mlx = new GenericMementoX(ml);
        Assert.assertEquals((long)4L, (long)ml.getAttributes().size());
        Assert.assertEquals((Object)"string", (Object)mlx.getAttribute("k1").getStringValue());
        Assert.assertEquals((Object)dateNow, (Object)mlx.getAttribute("k2").getDateValue());
        Assert.assertEquals((Object)new Long(99L), (Object)mlx.getAttribute("k3").getLongValue());
        Assert.assertEquals((Object)"hello", (Object)mlx.getAttribute("k4").getStringValue());
    }

    @Test
    public void persistenceManagerBase() {
        MemoryMementoStorage storage = new MemoryMementoStorage();
        PersistableManager manager = GenericMementoUtils.newPersistableManager((MementoStorage)storage, (TypeHandler)GenericMementoUtils.DEFAULT_TYPE_HANDLER);
        manager.persist((Persistable)this.getTestProperties());
        PersistableProperties p1 = (PersistableProperties)manager.load(Long.valueOf(0L));
        Assert.assertEquals((long)3L, (long)p1.size());
        Assert.assertEquals((Object)"v1", (Object)p1.get("p1"));
        Assert.assertEquals((Object)"v2", (Object)p1.get("p2"));
        Assert.assertEquals((Object)"v3", (Object)p1.get("p3"));
        Assert.assertEquals((long)1L, (long)p1.children.size());
        Assert.assertNull((Object)manager.load(Long.valueOf(99L)));
    }

    private PersistableProperties getTestProperties() {
        PersistableProperties pp = new PersistableProperties();
        pp.put("p1", "v1");
        pp.put("p2", "v2");
        pp.put("p3", "v3");
        PersistableProperties pp2 = new PersistableProperties();
        pp2.put("p21", "v21");
        pp2.put("p22", "v22");
        pp2.put("p23", "v23");
        PersistableProperties pp3 = new PersistableProperties();
        pp3.put("p31", "v31");
        pp3.put("p32", "v32");
        pp3.put("p33", "v33");
        pp.addChild(pp2);
        pp2.addChild(pp3);
        pp2.addChild(pp3);
        return pp;
    }

    public static class PersistableProperties
    extends ListOrderedMap<String, String>
    implements Persistable {
        private ArrayList<PersistableProperties> children = new ArrayList();

        public GenericMemento createMemento() {
            return this.createMemento(GenericMementoUtils.builder()).build();
        }

        private GenericMementoUtils.GenericMementoBuilder createMemento(GenericMementoUtils.GenericMementoBuilder builder) {
            for (String name : this.keySet()) {
                String val = ((String)this.get(name)).toString();
                builder.add(name, (Object)val);
            }
            for (PersistableProperties child : this.children) {
                GenericMementoUtils.GenericMementoBuilder childBuilder = builder.newChild();
                child.createMemento(childBuilder);
                childBuilder.childDone();
            }
            return builder;
        }

        public void setMemento(GenericMemento memento) {
            this.clear();
            this.children.clear();
            for (GenericMemento.MementoAttribute attr : memento.getAttributes()) {
                this.put(attr.getKey(), attr.getStringValue());
            }
            for (GenericMemento child : memento.getChildren()) {
                PersistableProperties pChild = new PersistableProperties();
                pChild.setMemento(child);
                this.addChild(pChild);
            }
        }

        public void addChild(PersistableProperties child) {
            this.children.add(child);
        }
    }
}

