/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.libs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

public class NioTest {
    public void nio_file() throws IOException {
        Path workingPath = Paths.get(".", new String[0]);
        Assert.assertEquals((String)".", (String)workingPath.toString());
        Assert.assertEquals((String)"C:\\prog\\java\\workspaces\\test\\ch.inftec.ju\\ju-util\\.", (String)workingPath.toAbsolutePath().toString());
        URI workingPathUri = workingPath.toUri();
        Assert.assertEquals((String)"file:///C:/prog/java/workspaces/test/ch.inftec.ju/ju-util/./", (String)workingPathUri.toString());
        File workingPathAsFile = workingPath.toFile();
        Assert.assertEquals((Object)workingPath, (Object)workingPathAsFile.toPath());
        FileSystem fileSystem = workingPath.getFileSystem();
        Iterator<Path> rootDirectories = fileSystem.getRootDirectories().iterator();
        Assert.assertEquals((Object)Paths.get("C:\\", new String[0]), (Object)rootDirectories.next());
        Assert.assertEquals((Object)Paths.get("D:\\", new String[0]), (Object)rootDirectories.next());
        Path testPath = workingPath.resolve("target/testDir");
        Assert.assertEquals((String)".\\target\\testDir", (String)testPath.toString());
        Assert.assertTrue((boolean)Files.exists(workingPath, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isDirectory(workingPath, new LinkOption[0]));
        Files.deleteIfExists(testPath);
        Files.createDirectories(testPath, new FileAttribute[0]);
        Path testFile = testPath.resolve("testFile.txt");
        Files.createFile(testFile, new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(testFile, Charset.forName("UTF-8"), StandardOpenOption.WRITE);){
            writer.append("Hello World!");
        }
        List<String> lines = Files.readAllLines(testFile, Charset.forName("UTF-8"));
        Assert.assertEquals((int)1, (int)lines.size());
        Assert.assertEquals((String)"Hello World!", (String)lines.get(0));
        Files.delete(testFile);
    }
}

