/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.io;

import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.io.NewLineReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.LineIterator;
import org.junit.Assert;
import org.junit.Test;

public class NewLineReaderTest {
    @Test
    public void autoDetect() throws Exception {
        String line1 = "I'm the first line";
        String line2 = "And I'm the second";
        String inputString = line1;
        NewLineReader r = new NewLineReader((Reader)new StringReader(inputString));
        LineIterator i = r.iterateLines();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)i.nextLine(), (Object)inputString);
        Assert.assertFalse((boolean)i.hasNext());
        Assert.assertNull((Object)r.getInputNewLine());
        Assert.assertNull((Object)r.getOutputNewLine());
        r.reset();
        String out1 = IOUtil.toString((Reader)r);
        Assert.assertEquals((Object)inputString, (Object)out1);
        inputString = line1 + "\n" + line2;
        r = new NewLineReader((Reader)new StringReader(inputString));
        i = r.iterateLines();
        Assert.assertEquals((Object)i.next(), (Object)line1);
        Assert.assertEquals((Object)r.getInputNewLine(), (Object)"\n");
        Assert.assertEquals((Object)r.getOutputNewLine(), (Object)"\n");
        Assert.assertEquals((Object)i.next(), (Object)line2);
        Assert.assertFalse((boolean)i.hasNext());
        r.reset();
        String out2 = IOUtil.toString((Reader)r);
        Assert.assertEquals((Object)inputString, (Object)out2);
        inputString = line1 + "\r\n" + line2 + "\r\n";
        r = new NewLineReader((Reader)new StringReader(inputString));
        i = r.iterateLines();
        Assert.assertEquals((Object)i.next(), (Object)line1);
        Assert.assertEquals((Object)r.getInputNewLine(), (Object)"\r\n");
        Assert.assertEquals((Object)r.getOutputNewLine(), (Object)"\r\n");
        Assert.assertEquals((Object)i.next(), (Object)line2);
        Assert.assertFalse((boolean)i.hasNext());
        r.reset();
        String out3 = IOUtil.toString((Reader)r);
        Assert.assertEquals((Object)inputString, (Object)out3);
    }

    @Test
    public void inputSet() throws IOException {
        String line1 = "I'm the \r first line";
        String line2 = "And I'm the second";
        String inputString = line1 + "\n" + line2;
        try (NewLineReader r = new NewLineReader((Reader)new StringReader(inputString), "\n", null);){
            char[] buf = new char[line1.length() + line2.length() + 1];
            r.read(buf, 0, buf.length);
            Assert.assertEquals((Object)line1, (Object)new String(buf, 0, line1.length()));
        }
    }

    @Test
    public void outputSet() throws Exception {
        String line1 = "I'm the first line";
        String line2 = "And I'm the second";
        String inputString = line1 + "\r\n" + line2;
        NewLineReader r = new NewLineReader((Reader)new StringReader(inputString), null, "\n");
        LineIterator i = r.iterateLines();
        Assert.assertEquals((Object)i.nextLine(), (Object)line1);
        Assert.assertEquals((Object)r.getInputNewLine(), (Object)"\r\n");
        Assert.assertEquals((Object)r.getOutputNewLine(), (Object)"\n");
        Assert.assertEquals((Object)i.nextLine(), (Object)line2);
        Assert.assertFalse((boolean)i.hasNext());
        r.reset();
        String out = IOUtil.toString((Reader)r);
        Assert.assertEquals((Object)(line1 + "\n" + line2), (Object)out);
    }
}

