/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.general;

import ch.inftec.ju.util.event.JuEventUtils;
import ch.inftec.ju.util.general.Descriptor;
import ch.inftec.ju.util.general.DescriptorUtils;
import java.util.EventListener;
import junit.framework.Assert;
import org.junit.Test;

public class DescriptorTest {
    private String evaluatorDescription;

    @Test
    public void descriptor() {
        Descriptor d = DescriptorUtils.newInstance((String)"Name", (String)"Description");
        Assert.assertEquals((String)"Name", (String)d.getName());
        Assert.assertEquals((String)"Description", (String)d.getDescription());
        Assert.assertEquals((String)"Name", (String)d.toString());
    }

    @Test
    public void descriptorBuilder() {
        Descriptor d = DescriptorUtils.builder((String)"Name").description("Description").setObject(Integer.class, (Object)1).setObject(Long.class, (Object)2L).getDescriptor();
        Assert.assertEquals((String)"Name", (String)d.getName());
        Assert.assertEquals((String)"Description", (String)d.getDescription());
        Assert.assertEquals((String)"Name", (String)d.toString());
        Assert.assertEquals((Object)1, (Object)d.getObject(Integer.class));
        Assert.assertEquals((Object)2L, (Object)d.getObject(Long.class));
    }

    @Test
    public void descripionEvaluator() {
        DescriptorUtils.AbstractDescriptionEvaluator descriptionEvaluator = new DescriptorUtils.AbstractDescriptionEvaluator(){

            protected String evaluateDescription() {
                return DescriptorTest.this.evaluatorDescription;
            }
        };
        Descriptor d = DescriptorUtils.builder((String)"Name").description("1").evaluator((DescriptorUtils.DescriptionEvaluator)descriptionEvaluator).getDescriptor();
        this.evaluatorDescription = "2";
        Assert.assertEquals((String)"2", (String)d.getDescription());
        this.evaluatorDescription = "3";
        Assert.assertEquals((String)"2", (String)d.getDescription());
        descriptionEvaluator.updateDescription();
        Assert.assertEquals((String)"3", (String)d.getDescription());
        JuEventUtils.TestUpdateListener testListener = JuEventUtils.newTestUpdateListener();
        d.getUpdateNotifier().addListener((EventListener)testListener);
        this.evaluatorDescription = "4";
        descriptionEvaluator.updateDescription();
        Assert.assertEquals((String)"4", (String)d.getDescription());
        testListener.assertOneCall();
    }
}

