/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JuUtilsTest {
    @Before
    public void clearPropertyChain_beforeTests() {
        JuUtils.clearPropertyChain();
    }

    @BeforeClass
    public static void clearPropertyChain_afterTests() {
        JuUtils.clearPropertyChain();
    }

    @Test
    public void propertyChain_isInitialized() {
        Assert.assertEquals((Object)"derby", (Object)JuUtils.getJuPropertyChain().get("ju-dbutil-test.profile"));
    }

    @Test
    public void propertyChain_priorizes_systemProperty() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-dbutil-test.profile", "myDerby");
            Assert.assertEquals((Object)"myDerby", (Object)JuUtils.getJuPropertyChain().get("ju-dbutil-test.profile"));
        }
    }

    @Test
    public void profile_isResolved_forPropertyFile() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-util.profile", "test");
            Assert.assertEquals((Object)"profileTestProps", (Object)JuUtils.getJuPropertyChain().get("ju-util.testProps"));
        }
    }

    @Test
    public void profile_isResolved_forCsvFile() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-util.profile", "testCsv");
            Assert.assertEquals((Object)"profileTestCsv", (Object)JuUtils.getJuPropertyChain().get("ju-util.testCsv"));
        }
    }

    @Test
    public void profile_isResolved_forCsvFile_usingDefault() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-util.profile", "testCsv");
            Assert.assertEquals((Object)"profileTestCsvDefault", (Object)JuUtils.getJuPropertyChain().get("ju-util.testCsvDefault"));
        }
    }
}

