/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUrl;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JuUrlTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void nonExistingResource_returnsNull() {
        Assert.assertNull((Object)JuUrl.resource((String)"blibla"));
    }

    @Test
    public void nonExistingResource_returnsNull_withBuilder() {
        Assert.assertNull((Object)JuUrl.resource().get("blibla"));
    }

    @Test
    public void resource_usingClassLookup() {
        Assert.assertNotNull((Object)JuUrl.resource().relativeTo(JuUrlTest.class).get("testResource.txt"));
    }

    @Test
    public void resource_usingClassLoader() {
        Assert.assertNotNull((Object)JuUrl.resource().get("ch/inftec/ju/util/testResource.txt"));
    }

    @Test
    public void multipleResources() {
        Assert.assertEquals((long)2L, (long)JuUrl.resource().getAll("ju.properties.files").size());
    }

    @Test
    public void exception_ifSingle_withMultipleResources() {
        this.thrown.expect(JuRuntimeException.class);
        this.thrown.expectMessage("Found more than");
        this.thrown.expectMessage("ju.properties.files");
        JuUrl.resource().single().get("ju.properties.files");
    }

    @Test
    public void exception_ifExceptionIfNone_andNoResource() {
        this.thrown.expect(JuRuntimeException.class);
        this.thrown.expectMessage("Resource not found");
        this.thrown.expectMessage("blibla");
        JuUrl.resource().exceptionIfNone().get("blibla");
    }

    @Test
    public void existingFile() {
        Assert.assertTrue((boolean)Files.exists(JuUrl.existingFile((String)"src/main/resources/ju.properties.files"), new LinkOption[0]));
    }

    @Test
    public void existingFile_usingRelativeTo() {
        Assert.assertTrue((boolean)Files.exists(JuUrl.path().relativeTo("src/main/resources", new String[0]).get("ju.properties.files"), new LinkOption[0]));
    }

    @Test
    public void existingFileMethod_throwsException_ifFileNotExisting() {
        this.thrown.expect(JuRuntimeException.class);
        this.thrown.expectMessage("Path doesn't exist");
        this.thrown.expectMessage("blibla");
        JuUrl.existingFile((String)"blibla");
    }

    @Test
    public void path_throwsException_ifPathIsNoFile() {
        this.thrown.expect(JuRuntimeException.class);
        this.thrown.expectMessage("Path is not a file");
        this.thrown.expectMessage("src");
        JuUrl.path().file().get("src/main");
    }
}

