/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.TestUtils;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Test;

public class IOTest {
    @Test
    public void loadTextFromUrl() throws Exception {
        String loadedString = new IOUtil("UTF-8").loadTextFromUrl(JuUrl.resource().relativeTo(IOTest.class).get("testResource.txt"), new String[0]);
        String expectedString = "First line\n";
        expectedString = expectedString + "Second line\n";
        expectedString = expectedString + "\u00e4\u00f6\u00fc\u00e9\u00e8\u00e3\u00e2";
        Assert.assertEquals((Object)loadedString, (Object)expectedString);
    }

    @Test
    public void assertEqualsResource() {
        String expectedString = "First line\n";
        expectedString = expectedString + "Second line\n";
        expectedString = expectedString + "\u00e4\u00f6\u00fc\u00e9\u00e8\u00e3\u00e2";
        TestUtils.assertEqualsResource((String)"testResource.txt", (String)expectedString, (String[])new String[0]);
        String expectedStringCrLf = "First line\r\n";
        expectedStringCrLf = expectedStringCrLf + "Second line\r\n";
        expectedStringCrLf = expectedStringCrLf + "\u00e4\u00f6\u00fc\u00e9\u00e8\u00e3\u00e2";
        TestUtils.assertEqualsResource((String)"testResource.txt", (String)expectedStringCrLf, (String[])new String[0]);
    }

    @Test
    public void loadTextFromUrlReplacement() throws Exception {
        String loadedString = new IOUtil("UTF-8").loadTextFromUrl(JuUrl.resource().relativeTo(IOTest.class).get("testResource_replacements.txt"), new String[]{"key1", "###val1###"});
        String expectedString = "First line ###val1###\n";
        expectedString = expectedString + "Second %key2% line\n";
        expectedString = expectedString + "\u00e4\u00f6\u00fc\u00e9\u00e8\u00e3\u00e2";
        Assert.assertEquals((Object)loadedString, (Object)expectedString);
        TestUtils.assertEqualsResource((String)"testResource_replacements.txt", (String)expectedString, (String[])new String[]{"key1", "###val1###"});
    }

    @Test(expected=ComparisonFailure.class)
    public void assertEqualsResource_fail() {
        TestUtils.assertEqualsResource((String)"testResource.txt", (String)"blibla", (String[])new String[0]);
    }

    @Test
    public void toNewLineUnix() {
        Assert.assertEquals((Object)"someString", (Object)IOUtil.toNewLineUnix((String)"someString"));
        String targetString = "line1\nline2";
        Assert.assertEquals((Object)targetString, (Object)IOUtil.toNewLineUnix((String)targetString));
        Assert.assertEquals((Object)targetString, (Object)IOUtil.toNewLineUnix((String)"line1\r\nline2"));
        Assert.assertEquals((Object)targetString, (Object)IOUtil.toNewLineUnix((String)"line1\rline2"));
    }

    @Test
    public void writeTextToFile() throws Exception {
        String text = "First line\n";
        text = text + "Second line\n";
        text = text + "\u00e4\u00f6\u00fc\u00e9\u00e8\u00e3\u00e2";
        Path tmpFile = IOUtil.getTemporaryFile();
        new IOUtil().writeTextToFile(text, tmpFile, true);
        String loadedText = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)tmpFile), new String[0]);
        TestUtils.assertEqualsResource((String)"testResource.txt", (String)loadedText, (String[])new String[0]);
    }

    @Test
    public void loadProperties() throws Exception {
        Properties props = new IOUtil("UTF-8").loadPropertiesFromUrl(JuUrl.resource().relativeTo(IOTest.class).get("test.properties"));
        Assert.assertEquals((Object)"First line", (Object)props.getProperty("prop1"));
        Assert.assertEquals((Object)"\u00e4\u00f6\u00fc\u00e9\u00e8\u00e3\u00e2", (Object)props.getProperty("prop2"));
    }

    @Test
    public void canDeleteFile() throws Exception {
        Path tempFile = IOUtil.getTemporaryFile();
        Assert.assertTrue((boolean)Files.exists(tempFile, new LinkOption[0]));
        IOUtil.deleteFile((Path)tempFile);
        Assert.assertFalse((boolean)Files.exists(tempFile, new LinkOption[0]));
    }

    @Test
    public void canWriteToFile_overwriting() throws Exception {
        Path tempFile = IOUtil.getTemporaryFile();
        new IOUtil().writeTextToFile("temp", tempFile, true);
        new IOUtil().writeTextToFile("overwrite", tempFile, true);
        String text = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)tempFile), new String[0]);
        Assert.assertEquals((Object)"overwrite", (Object)text);
    }

    @Test
    public void canOpenWriter_overwriting() throws Exception {
        Path tempFile = IOUtil.getTemporaryFile();
        new IOUtil().writeTextToFile("temp", tempFile, true);
        try (Writer w = new IOUtil().openWriter(tempFile, false, true);){
            w.write("overwrite");
        }
        String text = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)tempFile), new String[0]);
        Assert.assertEquals((Object)"overwrite", (Object)text);
    }

    @Test
    public void canOpenWriter_appending() throws Exception {
        Path tempFile = IOUtil.getTemporaryFile();
        new IOUtil().writeTextToFile("temp", tempFile, true);
        try (Writer w = new IOUtil().openWriter(tempFile, true, false);){
            w.write("append");
        }
        String text = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)tempFile), new String[0]);
        Assert.assertEquals((Object)"tempappend", (Object)text);
    }

    @Test
    public void canOpenWriter_newFile() throws Exception {
        Path tempFile = Paths.get("target/tmp/IOTest_canOpenWriter_newFile.txt", new String[0]);
        IOUtil.deleteFile((Path)tempFile);
        try (Writer w = new IOUtil().openWriter(tempFile, true, false);){
            w.write("new");
        }
        String text = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)tempFile), new String[0]);
        Assert.assertEquals((Object)"new", (Object)text);
    }
}

