package ch.inftec.ju.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JuUtilsTest {
	// We need to clear the cached chain to avoid side effects.
	
	@Before
	public void clearPropertyChain_beforeTests() {
		JuUtils.clearPropertyChain();
	}
	
	@BeforeClass
	public static void clearPropertyChain_afterTests() {
		JuUtils.clearPropertyChain();
	}
	
	@Test
	public void propertyChain_isInitialized() {
		Assert.assertEquals("derby", JuUtils.getJuPropertyChain().get("ju-dbutil-test.profile"));
	}
	
	@Test
	public void propertyChain_priorizes_systemProperty() {
		try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter()) {
			ts.setProperty("ju-dbutil-test.profile", "myDerby");
			
			Assert.assertEquals("myDerby", JuUtils.getJuPropertyChain().get("ju-dbutil-test.profile"));
		}
	}
	
	@Test
	public void profile_isResolved_forPropertyFile() {
		try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter()) {
			ts.setProperty("ju-util.profile", "test");
			
			Assert.assertEquals("profileTestProps", JuUtils.getJuPropertyChain().get("ju-util.testProps"));
		}
	}
		
	@Test
	public void profile_isResolved_forCsvFile() {
		try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter()) {
			ts.setProperty("ju-util.profile", "testCsv");
			
			Assert.assertEquals("profileTestCsv", JuUtils.getJuPropertyChain().get("ju-util.testCsv"));
		}
	}
	
	@Test
	public void profile_isResolved_forCsvFile_usingDefault() {
		try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter()) {
			ts.setProperty("ju-util.profile", "testCsv");
			
			Assert.assertEquals("profileTestCsvDefault", JuUtils.getJuPropertyChain().get("ju-util.testCsvDefault"));
		}
	}
}
