/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.test;

import ch.inftec.ju.ee.test.RemoteUtils;
import ch.inftec.ju.ee.test.TestRunnerAnnotationHandler;
import ch.inftec.ju.ee.test.TestRunnerFacade;
import ch.inftec.ju.ee.test.TestRunnerUtils;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import ch.inftec.ju.util.TestUtils;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Test;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTestRunnerRule
implements TestRule {
    private Logger logger = LoggerFactory.getLogger(ContainerTestRunnerRule.class);
    private final TestRunnerType type;

    public ContainerTestRunnerRule(TestRunnerType type) {
        this.type = type;
    }

    public Statement apply(Statement base, Description description) {
        Method method = TestUtils.getTestMethod((Description)description);
        Object testStatement = null;
        TestRunnerFacade.TestRunnerContext context = new TestRunnerFacade.TestRunnerContext();
        Path localRoot = Paths.get(".", new String[0]).toAbsolutePath();
        context.setLocalRoot(localRoot.toString());
        this.logger.info("New test context: " + context.getUuid());
        if (this.type == TestRunnerType.CONTAINER) {
            ContainerTestRunnerStatement containerTestRunnerStatement = new ContainerTestRunnerStatement(method, description, context);
            Test t = method.getAnnotation(Test.class);
            testStatement = t != null && t.expected() != Test.None.class ? new ExpectException((Statement)containerTestRunnerStatement, t.expected()) : containerTestRunnerStatement;
        } else {
            testStatement = base;
        }
        return new ContainerPreAndPostRunnerStatement(method, description, context, (Statement)testStatement);
    }

    private static class ContainerPreAndPostRunnerStatement
    extends ContainerRunnerStatement {
        private Logger logger = LoggerFactory.getLogger(ContainerPreAndPostRunnerStatement.class);
        private final Statement testStatement;

        private ContainerPreAndPostRunnerStatement(Method method, Description description, TestRunnerFacade.TestRunnerContext context, Statement testStatement) {
            super(method, description, context);
            this.testStatement = testStatement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doEvaluation(TestRunnerFacade facade, TestRunnerFacade.TestRunnerContext context) throws Throwable {
            TestRunnerAnnotationHandler handler = new TestRunnerAnnotationHandler(this.method, this.description, context);
            SystemPropertyTempSetter tempSetter = facade.runPreTestActionsInEjbContext(handler);
            try {
                this.testStatement.evaluate();
                facade.runPostTestActionsInEjbContext(handler);
            }
            finally {
                this.logger.debug("Cleaning up test run for context: " + handler.getUuid());
                facade.cleanupTestRun(handler, tempSetter);
            }
        }
    }

    private static class ContainerTestRunnerStatement
    extends ContainerRunnerStatement {
        private ContainerTestRunnerStatement(Method method, Description description, TestRunnerFacade.TestRunnerContext context) {
            super(method, description, context);
        }

        @Override
        protected void doEvaluation(TestRunnerFacade facade, TestRunnerFacade.TestRunnerContext context) throws Throwable {
            facade.runTestMethodInEjbContext(new TestRunnerAnnotationHandler(this.method, this.description, context));
        }
    }

    private static abstract class ContainerRunnerStatement
    extends Statement {
        protected final Method method;
        protected final Description description;
        protected final TestRunnerFacade.TestRunnerContext context;

        private ContainerRunnerStatement(Method method, Description description, TestRunnerFacade.TestRunnerContext context) {
            this.method = method;
            this.description = description;
            this.context = context;
        }

        public void evaluate() throws Throwable {
            try {
                this.doEvaluation(TestRunnerUtils.getTestRunnerFacade(), this.context);
            }
            catch (Throwable t) {
                throw RemoteUtils.getActualThrowable(t);
            }
        }

        protected abstract void doEvaluation(TestRunnerFacade var1, TestRunnerFacade.TestRunnerContext var2) throws Throwable;
    }

    public static enum TestRunnerType {
        CONTAINER,
        REMOTE_TEST;

    }
}

