/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.test;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.db.TxHandler;
import ch.inftec.ju.ee.client.ServiceLocator;
import ch.inftec.ju.ee.client.ServiceLocatorBuilder;
import ch.inftec.ju.ee.test.ContainerTestRunnerRule;
import ch.inftec.ju.ee.test.TestRunnerFacade;
import ch.inftec.ju.util.JuRuntimeException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.persistence.EntityManager;
import org.jboss.logging.Logger;
import org.junit.Rule;

public abstract class ContainerTest
implements TestRunnerFacade.ContextAware,
TestRunnerFacade.Initializable,
TestRunnerFacade.TransactionAware {
    protected Logger _log = Logger.getLogger(this.getClass());
    @Rule
    public ContainerTestRunnerRule testRunnerRule = new ContainerTestRunnerRule(ContainerTestRunnerRule.TestRunnerType.CONTAINER);
    private TestRunnerFacade.TestRunnerContext context;
    protected EntityManager em;
    protected JuEmUtil emUtil;
    protected TxHandler txHandler;
    protected ServiceLocator serviceLocator;

    @Override
    public final void setContext(TestRunnerFacade.TestRunnerContext context) {
        this.context = context;
    }

    @Override
    public void setTxHandler(TxHandler txHandler) {
        this.txHandler = txHandler;
    }

    @Override
    public final void init() {
        this.serviceLocator = ServiceLocatorBuilder.buildLocal().createServiceLocator();
        this.em = this.serviceLocator.cdi(EntityManager.class);
        this.emUtil = new JuEmUtil(this.em);
        this.doInit();
    }

    protected void doInit() {
    }

    protected void initFrom(ContainerTest hostTest) {
        this.context = hostTest.context;
        this.txHandler = hostTest.txHandler;
    }

    protected final Path getLocalPath(String relativePath, boolean createParentDirectories) {
        return this.getLocalPath(Paths.get(relativePath, new String[0]), createParentDirectories);
    }

    protected final Path getLocalPath(Path relativePath, boolean createParentDirectories) {
        Path localRoot = Paths.get(this.context.getLocalRoot(), new String[0]);
        Path localPath = localRoot.resolve(relativePath);
        if (createParentDirectories) {
            try {
                Files.createDirectories(localPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new JuRuntimeException("Couldn't create parent directories", (Throwable)ex);
            }
        }
        return localPath;
    }
}

