/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.cdi;

import ch.inftec.ju.ee.cdi.DynamicCdi;
import ch.inftec.ju.ee.cdi.DynamicCdiFactory;
import ch.inftec.ju.ee.cdi.DynamicCdiTag;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.ReflectUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DynamicCdiLoader {
    private Logger logger = LoggerFactory.getLogger(DynamicCdiLoader.class);
    @Inject
    @Any
    private Instance<DynamicCdi> dynamicCdis;

    public DynamicCdiLoader() {
    }

    public DynamicCdiLoader(Instance<DynamicCdi> dynamicCdis) {
        this.dynamicCdis = dynamicCdis;
    }

    public <T> T getImplementation(Class<T> clazz) {
        AssertUtil.assertNotNull((String)"Dynamic CDIs must be set or injected", this.dynamicCdis);
        String tagName = JuUtils.getJuPropertyChain().get(clazz.getName(), false);
        String defaultTagName = JuUtils.getJuPropertyChain().get("ju.ee.cdi.defaultDynamicCdiTag", "-");
        this.logger.debug("Looking for implementation of class {} (tag={}, defaultTag={})", new Object[]{clazz, tagName, defaultTagName});
        HashMap<String, TypeCreator<T>> implementations = new HashMap<String, TypeCreator<T>>();
        for (DynamicCdi simulatable : this.dynamicCdis) {
            if (DynamicCdiFactory.class.isAssignableFrom(simulatable.getClass())) {
                for (Method method : ReflectUtils.getDeclaredMethodsByAnnotation(simulatable.getClass(), DynamicCdiTag.class)) {
                    if (method.getReturnType() == null || method.getParameterTypes().length > 0) {
                        this.logger.warn("Illegal DynamicCdiFactory method. Must return a type and not have arguments: " + method);
                        continue;
                    }
                    if (!clazz.isAssignableFrom(method.getReturnType())) continue;
                    final DynamicCdi factory = simulatable;
                    final Method factoryMethod = method;
                    this.addType(clazz, implementations, method.getAnnotation(DynamicCdiTag.class), new TypeCreator<T>(){

                        @Override
                        public T createType() {
                            try {
                                Object t = factoryMethod.invoke((Object)factory, (Object[])null);
                                return t;
                            }
                            catch (Exception ex) {
                                throw new JuRuntimeException("Couldn't invoke method " + factoryMethod, (Throwable)ex);
                            }
                        }

                        public String toString() {
                            return factoryMethod.toString();
                        }
                    });
                }
                continue;
            }
            if (!clazz.isAssignableFrom(simulatable.getClass())) continue;
            final DynamicCdi type = simulatable;
            this.addType(clazz, implementations, type.getClass().getAnnotation(DynamicCdiTag.class), new TypeCreator<T>(){

                @Override
                public T createType() {
                    return type;
                }

                public String toString() {
                    return type.getClass().getName();
                }
            });
        }
        if (implementations.containsKey(tagName)) {
            this.logger.debug("Returning intance by tag match: {}", implementations.get(tagName));
            return ((TypeCreator)implementations.get(tagName)).createType();
        }
        if (implementations.containsKey(defaultTagName)) {
            this.logger.debug("Returning default instance: {}", implementations.get(defaultTagName));
            return ((TypeCreator)implementations.get(defaultTagName)).createType();
        }
        throw new JuRuntimeException(String.format("No dynamic implementation found for %s and tagName=%s or defaultTagName=%s", clazz.getName(), tagName, defaultTagName));
    }

    private <T> void addType(Class<?> clazz, Map<String, TypeCreator<T>> implementations, DynamicCdiTag tag, TypeCreator<T> typeCreator) {
        String tagValue = tag != null ? tag.value() : "-";
        this.logger.debug("Found implementation: {} (tag={})", (Object)typeCreator.toString(), (Object)tagValue);
        if (implementations.containsKey(tagValue)) {
            throw new JuRuntimeException(String.format("Found two Simulatable implementations for %s and tag=%s: %s and %s (more might exist)", clazz.getName(), tagValue, implementations.get(tagValue).toString(), typeCreator.toString()));
        }
        implementations.put(tagValue, typeCreator);
    }

    private static interface TypeCreator<T> {
        public T createType();
    }
}

